
package org.mule.modules.quickbooks.online.config;

import javax.annotation.Generated;
import org.mule.modules.quickbooks.online.config.AbstractDefinitionParser.ParseDelegate;
import org.mule.modules.quickbooks.online.processors.CreatePaymentMessageProcessor;
import org.mule.modules.quickbooks.online.schema.holders.CashPaymentExpressionHolder;
import org.mule.modules.quickbooks.online.schema.holders.CheckPaymentExpressionHolder;
import org.mule.modules.quickbooks.online.schema.holders.CreditCardPaymentExpressionHolder;
import org.mule.modules.quickbooks.online.schema.holders.CreditChargeInfoExpressionHolder;
import org.mule.modules.quickbooks.online.schema.holders.CreditChargeResponseExpressionHolder;
import org.mule.modules.quickbooks.online.schema.holders.IdTypeExpressionHolder;
import org.mule.modules.quickbooks.online.schema.holders.PaymentDetailExpressionHolder;
import org.mule.modules.quickbooks.online.schema.holders.PaymentExpressionHolder;
import org.mule.modules.quickbooks.online.schema.holders.PaymentHeaderExpressionHolder;
import org.mule.modules.quickbooks.online.schema.holders.PaymentLineExpressionHolder;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@Generated(value = "Mule DevKit Version 3.3.1", date = "2013-01-28T04:37:36-03:00", comments = "Build 3.3.1.1298.3ae82a7")
public class CreatePaymentDefinitionParser
    extends AbstractDefinitionParser
{


    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CreatePaymentMessageProcessor.class.getName());
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        parseConfigRef(element, builder);
        parseProperty(builder, element, "accessTokenId", "accessTokenId");
        if (!parseObjectRefWithDefault(element, builder, "payment", "payment", "#[payload]")) {
            BeanDefinitionBuilder paymentBuilder = BeanDefinitionBuilder.rootBeanDefinition(PaymentExpressionHolder.class.getName());
            Element paymentChildElement = DomUtils.getChildElementByTagName(element, "payment");
            if (paymentChildElement!= null) {
                if (!parseObjectRef(paymentChildElement, paymentBuilder, "header", "header")) {
                    BeanDefinitionBuilder _headerBuilder = BeanDefinitionBuilder.rootBeanDefinition(PaymentHeaderExpressionHolder.class.getName());
                    Element _headerChildElement = DomUtils.getChildElementByTagName(paymentChildElement, "header");
                    if (_headerChildElement!= null) {
                        if (!parseObjectRef(_headerChildElement, _headerBuilder, "customer-id", "customerId")) {
                            BeanDefinitionBuilder __customerIdBuilder = BeanDefinitionBuilder.rootBeanDefinition(IdTypeExpressionHolder.class.getName());
                            Element __customerIdChildElement = DomUtils.getChildElementByTagName(_headerChildElement, "customer-id");
                            if (__customerIdChildElement!= null) {
                                parseProperty(__customerIdBuilder, __customerIdChildElement, "value", "value");
                                parseProperty(__customerIdBuilder, __customerIdChildElement, "idDomain", "idDomain");
                                _headerBuilder.addPropertyValue("customerId", __customerIdBuilder.getBeanDefinition());
                            }
                        }
                        parseProperty(_headerBuilder, _headerChildElement, "customerName", "customerName");
                        if (!parseObjectRef(_headerChildElement, _headerBuilder, "job-id", "jobId")) {
                            BeanDefinitionBuilder __jobIdBuilder = BeanDefinitionBuilder.rootBeanDefinition(IdTypeExpressionHolder.class.getName());
                            Element __jobIdChildElement = DomUtils.getChildElementByTagName(_headerChildElement, "job-id");
                            if (__jobIdChildElement!= null) {
                                parseProperty(__jobIdBuilder, __jobIdChildElement, "value", "value");
                                parseProperty(__jobIdBuilder, __jobIdChildElement, "idDomain", "idDomain");
                                _headerBuilder.addPropertyValue("jobId", __jobIdBuilder.getBeanDefinition());
                            }
                        }
                        parseProperty(_headerBuilder, _headerChildElement, "jobName", "jobName");
                        if (!parseObjectRef(_headerChildElement, _headerBuilder, "remit-to-id", "remitToId")) {
                            BeanDefinitionBuilder __remitToIdBuilder = BeanDefinitionBuilder.rootBeanDefinition(IdTypeExpressionHolder.class.getName());
                            Element __remitToIdChildElement = DomUtils.getChildElementByTagName(_headerChildElement, "remit-to-id");
                            if (__remitToIdChildElement!= null) {
                                parseProperty(__remitToIdBuilder, __remitToIdChildElement, "value", "value");
                                parseProperty(__remitToIdBuilder, __remitToIdChildElement, "idDomain", "idDomain");
                                _headerBuilder.addPropertyValue("remitToId", __remitToIdBuilder.getBeanDefinition());
                            }
                        }
                        parseProperty(_headerBuilder, _headerChildElement, "remitToName", "remitToName");
                        if (!parseObjectRef(_headerChildElement, _headerBuilder, "deposit-to-account-id", "depositToAccountId")) {
                            BeanDefinitionBuilder __depositToAccountIdBuilder = BeanDefinitionBuilder.rootBeanDefinition(IdTypeExpressionHolder.class.getName());
                            Element __depositToAccountIdChildElement = DomUtils.getChildElementByTagName(_headerChildElement, "deposit-to-account-id");
                            if (__depositToAccountIdChildElement!= null) {
                                parseProperty(__depositToAccountIdBuilder, __depositToAccountIdChildElement, "value", "value");
                                parseProperty(__depositToAccountIdBuilder, __depositToAccountIdChildElement, "idDomain", "idDomain");
                                _headerBuilder.addPropertyValue("depositToAccountId", __depositToAccountIdBuilder.getBeanDefinition());
                            }
                        }
                        parseProperty(_headerBuilder, _headerChildElement, "depositToAccountName", "depositToAccountName");
                        if (!parseObjectRef(_headerChildElement, _headerBuilder, "payment-method-id", "paymentMethodId")) {
                            BeanDefinitionBuilder __paymentMethodIdBuilder = BeanDefinitionBuilder.rootBeanDefinition(IdTypeExpressionHolder.class.getName());
                            Element __paymentMethodIdChildElement = DomUtils.getChildElementByTagName(_headerChildElement, "payment-method-id");
                            if (__paymentMethodIdChildElement!= null) {
                                parseProperty(__paymentMethodIdBuilder, __paymentMethodIdChildElement, "value", "value");
                                parseProperty(__paymentMethodIdBuilder, __paymentMethodIdChildElement, "idDomain", "idDomain");
                                _headerBuilder.addPropertyValue("paymentMethodId", __paymentMethodIdBuilder.getBeanDefinition());
                            }
                        }
                        parseProperty(_headerBuilder, _headerChildElement, "paymentMethodName", "paymentMethodName");
                        if (!parseObjectRef(_headerChildElement, _headerBuilder, "detail", "detail")) {
                            BeanDefinitionBuilder __detailBuilder = BeanDefinitionBuilder.rootBeanDefinition(PaymentDetailExpressionHolder.class.getName());
                            Element __detailChildElement = DomUtils.getChildElementByTagName(_headerChildElement, "detail");
                            if (__detailChildElement!= null) {
                                if (!parseObjectRef(__detailChildElement, __detailBuilder, "cash", "cash")) {
                                    BeanDefinitionBuilder ___cashBuilder = BeanDefinitionBuilder.rootBeanDefinition(CashPaymentExpressionHolder.class.getName());
                                    Element ___cashChildElement = DomUtils.getChildElementByTagName(__detailChildElement, "cash");
                                    if (___cashChildElement!= null) {
                                        parseProperty(___cashBuilder, ___cashChildElement, "desc", "desc");
                                        __detailBuilder.addPropertyValue("cash", ___cashBuilder.getBeanDefinition());
                                    }
                                }
                                if (!parseObjectRef(__detailChildElement, __detailBuilder, "credit-card", "creditCard")) {
                                    BeanDefinitionBuilder ___creditCardBuilder = BeanDefinitionBuilder.rootBeanDefinition(CreditCardPaymentExpressionHolder.class.getName());
                                    Element ___creditCardChildElement = DomUtils.getChildElementByTagName(__detailChildElement, "credit-card");
                                    if (___creditCardChildElement!= null) {
                                        if (!parseObjectRef(___creditCardChildElement, ___creditCardBuilder, "credit-charge-info", "creditChargeInfo")) {
                                            BeanDefinitionBuilder ____creditChargeInfoBuilder = BeanDefinitionBuilder.rootBeanDefinition(CreditChargeInfoExpressionHolder.class.getName());
                                            Element ____creditChargeInfoChildElement = DomUtils.getChildElementByTagName(___creditCardChildElement, "credit-charge-info");
                                            if (____creditChargeInfoChildElement!= null) {
                                                parseProperty(____creditChargeInfoBuilder, ____creditChargeInfoChildElement, "number", "number");
                                                parseProperty(____creditChargeInfoBuilder, ____creditChargeInfoChildElement, "token", "token");
                                                parseProperty(____creditChargeInfoBuilder, ____creditChargeInfoChildElement, "type", "type");
                                                parseProperty(____creditChargeInfoBuilder, ____creditChargeInfoChildElement, "nameOnAcct", "nameOnAcct");
                                                parseProperty(____creditChargeInfoBuilder, ____creditChargeInfoChildElement, "ccExpirMn", "ccExpirMn");
                                                parseProperty(____creditChargeInfoBuilder, ____creditChargeInfoChildElement, "ccExpirYr", "ccExpirYr");
                                                parseProperty(____creditChargeInfoBuilder, ____creditChargeInfoChildElement, "billAddrStreet", "billAddrStreet");
                                                parseProperty(____creditChargeInfoBuilder, ____creditChargeInfoChildElement, "zipCode", "zipCode");
                                                parseProperty(____creditChargeInfoBuilder, ____creditChargeInfoChildElement, "cvv", "cvv");
                                                parseProperty(____creditChargeInfoBuilder, ____creditChargeInfoChildElement, "commercialCardCode", "commercialCardCode");
                                                ___creditCardBuilder.addPropertyValue("creditChargeInfo", ____creditChargeInfoBuilder.getBeanDefinition());
                                            }
                                        }
                                        if (!parseObjectRef(___creditCardChildElement, ___creditCardBuilder, "credit-charge-response", "creditChargeResponse")) {
                                            BeanDefinitionBuilder ____creditChargeResponseBuilder = BeanDefinitionBuilder.rootBeanDefinition(CreditChargeResponseExpressionHolder.class.getName());
                                            Element ____creditChargeResponseChildElement = DomUtils.getChildElementByTagName(___creditCardChildElement, "credit-charge-response");
                                            if (____creditChargeResponseChildElement!= null) {
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "status", "status");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "resultCode", "resultCode");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "resultMsg", "resultMsg");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "merchantAcctNum", "merchantAcctNum");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "cardSecurityCodeMatch", "cardSecurityCodeMatch");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "authCode", "authCode");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "avsStreet", "avsStreet");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "avsZip", "avsZip");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "securityCode", "securityCode");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "reconBatchId", "reconBatchId");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "paymentGroupingCode", "paymentGroupingCode");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "txnAuthorizationTime", "txnAuthorizationTime");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "txnAuthorizationStamp", "txnAuthorizationStamp");
                                                parseProperty(____creditChargeResponseBuilder, ____creditChargeResponseChildElement, "clientTransID", "clientTransID");
                                                ___creditCardBuilder.addPropertyValue("creditChargeResponse", ____creditChargeResponseBuilder.getBeanDefinition());
                                            }
                                        }
                                        __detailBuilder.addPropertyValue("creditCard", ___creditCardBuilder.getBeanDefinition());
                                    }
                                }
                                if (!parseObjectRef(__detailChildElement, __detailBuilder, "check", "check")) {
                                    BeanDefinitionBuilder ___checkBuilder = BeanDefinitionBuilder.rootBeanDefinition(CheckPaymentExpressionHolder.class.getName());
                                    Element ___checkChildElement = DomUtils.getChildElementByTagName(__detailChildElement, "check");
                                    if (___checkChildElement!= null) {
                                        parseProperty(___checkBuilder, ___checkChildElement, "checkNum", "checkNum");
                                        parseProperty(___checkBuilder, ___checkChildElement, "status", "status");
                                        parseProperty(___checkBuilder, ___checkChildElement, "nameOnAcct", "nameOnAcct");
                                        parseProperty(___checkBuilder, ___checkChildElement, "acctNum", "acctNum");
                                        parseProperty(___checkBuilder, ___checkChildElement, "routingNum", "routingNum");
                                        parseProperty(___checkBuilder, ___checkChildElement, "bankName", "bankName");
                                        __detailBuilder.addPropertyValue("check", ___checkBuilder.getBeanDefinition());
                                    }
                                }
                                _headerBuilder.addPropertyValue("detail", __detailBuilder.getBeanDefinition());
                            }
                        }
                        parseProperty(_headerBuilder, _headerChildElement, "totalAmt", "totalAmt");
                        parseProperty(_headerBuilder, _headerChildElement, "unappliedAmt", "unappliedAmt");
                        parseProperty(_headerBuilder, _headerChildElement, "processPayment", "processPayment");
                        paymentBuilder.addPropertyValue("header", _headerBuilder.getBeanDefinition());
                    }
                }
                parseListAndSetProperty(paymentChildElement, paymentBuilder, "line", "line", "line", new ParseDelegate<BeanDefinition>() {


                    public BeanDefinition parse(Element element) {
                        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(PaymentLineExpressionHolder.class);
                        parseProperty(builder, element, "amount", "amount");
                        if (!parseObjectRef(element, builder, "txn-id", "txnId")) {
                            BeanDefinitionBuilder __txnIdBuilder = BeanDefinitionBuilder.rootBeanDefinition(IdTypeExpressionHolder.class.getName());
                            Element __txnIdChildElement = DomUtils.getChildElementByTagName(element, "txn-id");
                            if (__txnIdChildElement!= null) {
                                parseProperty(__txnIdBuilder, __txnIdChildElement, "value", "value");
                                parseProperty(__txnIdBuilder, __txnIdChildElement, "idDomain", "idDomain");
                                builder.addPropertyValue("txnId", __txnIdBuilder.getBeanDefinition());
                            }
                        }
                        parseProperty(builder, element, "txnNum", "txnNum");
                        parseProperty(builder, element, "discountAmt", "discountAmt");
                        if (!parseObjectRef(element, builder, "discount-id", "discountId")) {
                            BeanDefinitionBuilder __discountIdBuilder = BeanDefinitionBuilder.rootBeanDefinition(IdTypeExpressionHolder.class.getName());
                            Element __discountIdChildElement = DomUtils.getChildElementByTagName(element, "discount-id");
                            if (__discountIdChildElement!= null) {
                                parseProperty(__discountIdBuilder, __discountIdChildElement, "value", "value");
                                parseProperty(__discountIdBuilder, __discountIdChildElement, "idDomain", "idDomain");
                                builder.addPropertyValue("discountId", __discountIdBuilder.getBeanDefinition());
                            }
                        }
                        parseProperty(builder, element, "discountName", "discountName");
                        if (!parseObjectRef(element, builder, "discount-account-id", "discountAccountId")) {
                            BeanDefinitionBuilder __discountAccountIdBuilder = BeanDefinitionBuilder.rootBeanDefinition(IdTypeExpressionHolder.class.getName());
                            Element __discountAccountIdChildElement = DomUtils.getChildElementByTagName(element, "discount-account-id");
                            if (__discountAccountIdChildElement!= null) {
                                parseProperty(__discountAccountIdBuilder, __discountAccountIdChildElement, "value", "value");
                                parseProperty(__discountAccountIdBuilder, __discountAccountIdChildElement, "idDomain", "idDomain");
                                builder.addPropertyValue("discountAccountId", __discountAccountIdBuilder.getBeanDefinition());
                            }
                        }
                        parseProperty(builder, element, "discountAccountName", "discountAccountName");
                        return builder.getBeanDefinition();
                    }

                }
                );
                builder.addPropertyValue("payment", paymentBuilder.getBeanDefinition());
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
