/**
 * Mule QuickBooks Connector
 *
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, vhudson-jaxb-ri-2.1-833 
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a> 
// Any modifications to this file will be lost upon recompilation of the source schema. 
// Generated on: 2011.08.30 at 12:47:01 PM ART 
//

package org.mule.modules.quickbooks.online;

import org.mule.modules.quickbooks.online.schema.QboAccountDetailTypeEnum;


/**
 * Enumeration that contains the sub-types of accounts.
 * 
 * @author Gaston Ponti
 * @since Oct 5, 2011
 */
public enum AccountOnlineDetail
{

    /**
     * Accounts Payable (also called A/P) tracks amounts you owe to your vendors and
     * suppliers. QBO automatically creates one Accounts Payable account for you.
     * Most businesses need only one.
     */

    ACCOUNTS_PAYABLE("AccountsPayable"),

    /**
     * Accounts Receivable (also called A/R) tracks money that customers owe
     * businesses for products or services, and payments customers make. QBO
     * automatically creates one Accounts Receivable account for you. Most businesses
     * need only one. Each customer has a register, which functions like an A/R
     * account.
     */

    ACCOUNTS_RECEIVABLE("AccountsReceivable"),

    /**
     * S corporations use this account to track adjustments to owner's equity that
     * are not attributable to net income.
     */

    ACCUMULATED_ADJUSTMENT("AccumulatedAdjustment"),

    /**
     * Use Accumulated Amortization to track how much you amortize intangible assets.
     */

    ACCUMULATED_AMORTIZATION("AccumulatedAmortization"),

    /**
     * Use Accumulated Amortization of Other Assets to track how much you've
     * amortized an asset whose type is Other Asset.
     */

    ACCUMULATED_AMORTIZATION_OF_OTHER_ASSETS("AccumulatedAmortizationOfOtherAssets"),

    /**
     * Use Accumulated Depletion to track how much you deplete a natural resource.
     */

    ACCUMULATED_DEPLETION("AccumulatedDepletion"),

    /**
     * Use Accumulated Depreciation to track how much you depreciate a fixed asset (a
     * physical asset you do not expect to convert to cash during one year of normal
     * operations).
     */

    ACCUMULATED_DEPRECIATION("AccumulatedDepreciation"),

    /**
     * Use Advertising/Promotional to track money spent promoting your company. You
     * may want different accounts of this type to track different promotional
     * efforts (Yellow Pages, newspaper, radio, flyers, events, and so on). If the
     * promotion effort is a meal, use Promotional Meals, instead.
     */

    ADVERTISING_PROMOTIONAL("AdvertisingPromotional"),

    /**
     * Use Allowance for Bad Debts to estimate the portion of Accounts receivable you
     * think you might not collect. Use this only if you are keeping your books on
     * the accrual basis.
     */

    ALLOWANCE_FOR_BAD_DEBTS("AllowanceForBadDebts"),

    /**
     * Use Amortization to track amortization of intangible assets.
     */

    AMORTIZATION("Amortization"),

    /**
     * Use Auto to track costs associated with vehicles. You may want different
     * accounts of this type to track gasoline, repairs, and maintenance. If your
     * business owns a car or truck, you may want to track its value as a Fixed
     * Asset, in addition to tracking its expenses.
     */

    AUTO("Auto"),

    /**
     * Use Bad Debt to track debt you have written off.
     */

    BAD_DEBTS("BadDebts"),

    /**
     * Use Bank Charges for any fees you pay to financial institutions.
     */

    BANK_CHARGES("BankCharges"),

    /**
     * Use Buildings to track the cost of structures you own and use for your
     * business. If you have a business in your home, consult your accountant or IRS
     * Publication 587. Use a Land account for the land portion of any real property
     * you own, splitting the cost of the property between land and building in a
     * logical method. One often-used method is to mimic the land-to-building ratio
     * on the property tax statement.
     */

    BUILDINGS("Buildings"),

    /**
     * Use a Cash on Hand account to track cash your company keeps for occasional
     * expenses, also called petty cash. To track cash from sales that have not been
     * deposited yet, use a pre-created account called Undeposited funds, instead.
     */

    CASH_ON_HAND("CashOnHand"),

    /**
     * Use Charitable Contributions to track gifts to charity.
     */

    CHARITABLE_CONTRIBUTIONS("CharitableContributions"),

    /**
     * Use Checking Accounts to track all checking activity, including debit card
     * transactions.
     */

    CHECKING("Checking"),

    /**
     * Corporations use this account to track shares of its common stock in the hands
     * of shareholders. The amount in this account should be the stated (or par)
     * value of the stock.
     */

    COMMON_STOCK("CommonStock"),

    /**
     * Use Cost of Labor to track the cost of paying employees to produce products or
     * supply services. It includes all employment costs, including food and
     * transportation, if applicable.
     */

    COST_OF_LABOR("CostOfLabor"),

    /**
     * Use Cost of Labor to track the cost of paying employees to produce products or
     * supply services. It includes all employment costs, including food and
     * transportation, if applicable.
     */

    COST_OF_LABOR_COS("CostOfLaborCos"),

    /**
     * Credit Card accounts track the balance due on your business credit cards.
     */

    CREDIT_CARD("CreditCard"),

    /**
     * Use Depletable Assets to track natural resources, such as timberlands, oil
     * wells, and mineral deposits.
     */

    DEPLETABLE_ASSETS("DepletableAssets"),

    /**
     * Use Depreciation to track how much you depreciate fixed assets.
     */

    DEPRECIATION("Depreciation"),

    /**
     * Use Development Costs to track amounts you deposit or set aside to arrange for
     * financing, such as an SBA loan, or for deposits in anticipation of the
     * purchase of property or other assets. When the deposit is refunded, or the
     * purchase takes place, remove the amount from this account.
     */

    DEVELOPMENT_COSTS("DevelopmentCosts"),

    /**
     * Use Direct Deposit Payable to keep track of net pay that you intend to pay
     * employees and contractors through direct deposit.
     */

    DIRECT_DEPOSIT_PAYABLE("DirectDepositPayable"),

    /**
     * Use Discounts/Refunds Given to track discounts you give to customers. This
     * account typically has a negative balance so it offsets other income. For
     * discounts from vendors, use an expense account, instead.
     */

    DISCOUNTS_REFUNDS_GIVEN("DiscountsRefundsGiven"),

    /**
     * Use Dividend Income to track taxable dividends from investments.
     */

    DIVIDEND_INCOME("DividendIncome"),

    /**
     * Use Dues and Subscriptions to track dues and subscriptions related to running
     * your business. You may want different accounts of this type for professional
     * dues, fees for licenses that can't be transferred, magazines, newspapers,
     * industry publications, or service subscriptions.
     */

    DUES_SUBSCRIPTIONS("DuesSubscriptions"),

    /**
     * Use Employee Cash Advances to track employee wages and salary you issue to an
     * employee early, or other non-salary money given to employees. If you make a
     * loan to an employee, use the Other current asset account type called Loans to
     * others, instead.
     */

    EMPLOYEE_CASH_ADVANCES("EmployeeCashAdvances"),

    /**
     * Use Entertainment to track events to entertain employees. If the event is a
     * meal, use Entertainment Meals, instead.
     */

    ENTERTAINMENT("Entertainment"),

    /**
     * Use Entertainment Meals to track how much you spend on dining with your
     * employees to promote morale. If you dine with a customer to promote your
     * business, use a Promotional Meals account, instead. Be sure to include who you
     * ate with and the purpose of the meal when you enter the transaction.
     */

    ENTERTAINMENT_MEALS("EntertainmentMeals"),

    /**
     * Use Equipment Rental to track the cost of renting equipment to produce
     * products or services.
     */

    EQUIPMENT_RENTAL("EquipmentRental"),

    /**
     * Use Equipment Rental to track the cost of renting equipment to produce
     * products or services. If you purchase equipment, use a Fixed Asset account
     * type called Machinery and Equipment.
     */

    EQUIPMENT_RENTAL_COS("EquipmentRentalCos"),

    /**
     * Use Federal Income Tax Payable if your business is a corporation, S
     * corporation, or limited partnership keeping records on the accrual basis. This
     * account tracks income tax liabilities in the year the income is earned.
     */

    FEDERAL_INCOME_TAX_PAYABLE("FederalIncomeTaxPayable"),

    /**
     * Use Furniture and Fixtures to track any furniture and fixtures your business
     * owns and uses, like a dental chair or sales booth.
     */

    FURNITURE_AND_FIXTURES("FurnitureAndFixtures"),

    /**
     * Use Goodwill only if you have acquired another company. It represents the
     * intangible assets of the acquired company which gave it an advantage, such as
     * favorable government relations, business name, outstanding credit ratings,
     * location, superior management, customer lists, product quality, or good labor
     * relations.
     */

    GOODWILL("Goodwill"),

    /**
     * Use Insurance to track insurance payments. You may want different accounts of
     * this type for different types of insurance (auto, general liability, and so
     * on).
     */

    INSURANCE("Insurance"),

    /**
     * Use Insurance Payable to keep track of insurance amounts due. This account is
     * most useful for businesses with monthly recurring insurance expenses such as
     * Workers' Compensation.
     */

    INSURANCE_PAYABLE("InsurancePayable"),

    /**
     * Use Intangible Assets to track intangibles that you plan to amortize. Examples
     * include franchises, copyrights, and patents.
     */

    INTANGIBLE_ASSETS("IntangibleAssets"),

    /**
     * Use Interest Earned to track interest from bank or savings accounts,
     * investments, or interest payments to you on loans your business made.
     */

    INTEREST_EARNED("InterestEarned"),

    /**
     * Use Interest Paid for all types of interest you pay, including mortgage
     * interest, finance charges on credit cards, or interest on loans.
     */

    INTEREST_PAID("InterestPaid"),

    /**
     * Use Inventory to track the cost of goods your business purchases for resale.
     * When the goods are sold, assign the sale to a Cost of goods sold account.
     */

    INVENTORY("Inventory"),

    /**
     * Use Investments - Mortgage/Real Estate Loans to show the balances of any
     * mortgage or real estate loans your business has made or purchased.
     */

    INVESTMENT_MORTGAGE_REAL_ESTATE_LOANS("Investment_MortgageRealEstateLoans"),

    /**
     * Use Investments - Other to track the value of investments not covered by other
     * investment account types. Examples include publicly-traded stocks, coins, or
     * gold.
     */

    INVESTMENT_OTHER("Investment_Other"),

    /**
     * Use Investments - Tax-Exempt Securities for investments in state and local
     * bonds, or mutual funds that invest in state and local bonds.
     */

    INVESTMENT_TAX_EXEMPT_SECURITIES("Investment_TaxExemptSecurities"),

    /**
     * Use Investments - U.S. Government Obligations for bonds issued by the U.S.
     * government.
     */

    INVESTMENT_US_GOVERNMENT_OBLIGATIONS("Investment_USGovernmentObligations"),

    /**
     * Use Land for land or property you don't depreciate. If land and building were
     * acquired together, split the cost between the two in a logical way. One common
     * method is to use the land-to-building ratio on the property tax statement. For
     * land you use as a natural resource, use a Depletable Assets account, instead.
     */

    LAND("Land"),

    /**
     * Use Lease Buyout to track lease payments to be applied toward the purchase of
     * a leased asset.
     */

    LEASE_BUYOUT("LeaseBuyout"),

    /**
     * Use Leasehold Improvements to track improvements to a leased asset that
     * increases the asset's value. For example, if you carpet a leased office space
     * and are not reimbursed, that's a leasehold improvement.
     */

    LEASEHOLD_IMPROVEMENTS("LeaseholdImprovements"),

    /**
     * Use Legal and Professional Fees to track money to pay to professionals to help
     * you run your business. You may want different accounts of this type for
     * payments to your accountant, lawyer, or other consultants.
     */

    LEGAL_PROFESSIONAL_FEES("LegalProfessionalFees"),

    /**
     * Use Licenses to track non-professional licenses for permission to engage in an
     * activity, like selling alcohol or radio broadcasting.
     */

    LICENSES("Licenses"),

    /**
     * Use Line of Credit to track the balance due on any lines of credit your
     * business has. Each line of credit your business has should have its own Line
     * of Credit account.
     */

    LINE_OF_CREDIT("LineOfCredit"),

    /**
     * Use Loan Payable to track loans your business owes which are payable within
     * the next twelve months. For longer-term loans, use the Long-term liability
     * called Notes Payable, instead.
     */

    LOAN_PAYABLE("LoanPayable"),

    /**
     * If you operate your business as a Corporation or S Corporation, use Loans to
     * Officers to track money loaned to officers of your business.
     */

    LOANS_TO_OFFICERS("LoansToOfficers"),

    /**
     * Use Loans to Others to track money your business loans to other people or
     * businesses. This type of account is also referred to as Notes Receivable.
     */

    LOANS_TO_OTHERS("LoansToOthers"),

    /**
     * If you operate your business as a Corporation or S Corporation, use Loans to
     * Stockholders to track money your business loans to its stockholders.
     */

    LOANS_TO_STOCKHOLDERS("LoansToStockholders"),

    /**
     * Use Machinery and equipment to track computer hardware, as well as any other
     * non-furniture fixtures or devices owned and used for your business. This
     * includes equipment that you ride, like tractors and lawn mowers. Cars and
     * trucks, however, should be tracked with Vehicle Accounts, instead.
     */

    MACHINERY_AND_EQUIPMENT("MachineryAndEquipment"),

    /**
     * Use Money Market to track amounts in money market accounts.
     */

    MONEY_MARKET("MoneyMarket"),

    /**
     * Use Non-Profit Income to track money coming in if you are a non-profit
     * organization.
     */

    NON_PROFIT_INCOME("NonProfitIncome"),

    /**
     * Use Notes Payable to track the amounts your business owes in long-term (over
     * twelve months) loans. For shorter loans, use the Other current liability
     * account type called Loan Payable, instead.
     */

    NOTES_PAYABLE("NotesPayable"),

    /**
     * Use Office/General Administrative Expenses to track all types of general or
     * office-related expenses.
     */

    OFFICE_GENERAL_ADMINISTRATIVE_EXPENSES("OfficeGeneralAdministrativeExpenses"),

    /**
     * QBO creates this account the first time you enter an opening balance for a
     * balance sheet account. As you enter opening balances, QBO records the amounts
     * in Opening Balance Equity.
     */

    OPENING_BALANCE_EQUITY("OpeningBalanceEquity"),

    /**
     * Use Organizational Costs to track costs incurred when forming a partnership or
     * corporation. The costs include the legal and accounting costs necessary to
     * organize the company, facilitate the filings of the legal documents, and other
     * paperwork.
     */

    ORGANIZATIONAL_COSTS("OrganizationalCosts"),

    /**
     * Use Other Costs of Service to track costs related to services you provide that
     * don't fall into another Cost of Goods Sold type.
     */

    OTHER_COSTS_OF_SERVICE_COS("OtherCostsOfServiceCos"),

    /**
     * Use Other Current Assets for current assets not covered by the other types.
     * Current assets are likely to be converted to cash or used up in a year.
     */

    OTHER_CURRENT_ASSETS("OtherCurrentAssets"),

    /**
     * Use Other Current Liabilities to track liabilities due within the next twelve
     * months that do not fit the Other current liability account types.
     */

    OTHER_CURRENT_LIABILITIES("OtherCurrentLiabilities"),

    /**
     * Use Other Fixed Asset for fixed assets that are not covered by other asset
     * types. Fixed assets are physical property you use in your business and do not
     * expect to convert to cash or be used up during one year of normal operations.
     */

    OTHER_FIXED_ASSETS("OtherFixedAssets"),

    /**
     * Use Other Investment Income to track other types of investment income that
     * isn't from dividends or interest.
     */

    OTHER_INVESTMENT_INCOME("OtherInvestmentIncome"),

    /**
     * Use Other Long-Term Assets to track assets not covered by other types. Long
     * term assets are expected to provide value for more than one year.
     */

    OTHER_LONG_TERM_ASSETS("OtherLongTermAssets"),

    /**
     * Use Other Long Term Liabilities to track liabilities due in more than twelve
     * months that don't fit the other Long-term liability account types.
     */

    OTHER_LONG_TERM_LIABILITIES("OtherLongTermLiabilities"),

    /**
     * Use Other Miscellaneous Expense to track unusual or infrequent expenses that
     * don't fall into another Other Expense type.
     */

    OTHER_MISCELLANEOUS_EXPENSE("OtherMiscellaneousExpense"),

    /**
     * Use Other Miscellaneous Income to track income that isn't from normal business
     * operations, and doesn't fall into another Other Income type.
     */

    OTHER_MISCELLANEOUS_INCOME("OtherMiscellaneousIncome"),

    /**
     * Use Other Miscellaneous Service Cost to track costs related to providing
     * services that don't fall into another Expense type.
     */

    OTHER_MISCELLANEOUS_SERVICE_COST("OtherMiscellaneousServiceCost"),

    /**
     * Use Other Primary Income to track income from normal business operations that
     * doesn't fall into another Income type.
     */

    OTHER_PRIMARY_INCOME("OtherPrimaryIncome"),

    /**
     * S corporations use Owner's Equity to show the cumulative net income or loss of
     * their business as of the beginning of the fiscal year.
     */

    OWNERS_EQUITY("OwnersEquity"),

    /**
     * Corporations use Paid-In Capital to track amounts received from shareholders
     * in exchange for stock that are over and above the stock's stated (or par)
     * value.
     */

    PAID_IN_CAPITAL_OR_SURPLUS("PaidInCapitalOrSurplus"),

    /**
     * Partnerships use Partner Contributions to track amounts partners contribute to
     * the partnership during the year.
     */

    PARTNER_CONTRIBUTIONS("PartnerContributions"),

    /**
     * Partnerships use Partner Distributions to track amounts distributed by the
     * partnership to its partners during the year.
     */

    PARTNER_DISTRIBUTIONS("PartnerDistributions"),

    /**
     * Partnerships use Partner's Equity to show the income remaining in the
     * partnership for each partner as of the end of the prior year.
     */

    PARTNERS_EQUITY("PartnersEquity"),

    /**
     * Use Payroll Clearing to keep track of any non-tax amounts that you have
     * deducted from employee paychecks or that you owe as a result of doing payroll.
     * When you forward money to the appropriate vendors, deduct the amount from the
     * balance of this account.
     */

    PAYROLL_CLEARING("PayrollClearing"),

    /**
     * Use Payroll Expenses to track payroll expenses.
     */

    PAYROLL_EXPENSES("PayrollExpenses"),

    /**
     * Use Payroll Tax Payable to keep track of tax amounts that you owe to Federal,
     * State, and Local government agencies as a result of paying wages and taxes you
     * have withheld from employee paychecks. When you forward the money to the
     * government agency, deduct the amount from the balance of this account.
     */

    PAYROLL_TAX_PAYABLE("PayrollTaxPayable"),

    /**
     * Use Penalties and Settlements to track money you pay for violating laws or
     * regulations, settling lawsuits, or other penalties.
     */

    PENALTIES_SETTLEMENTS("PenaltiesSettlements"),

    /**
     * Corporations use this account to track shares of its preferred stock in the
     * hands of shareholders. The amount in this account should be the stated (or
     * par) value of the stock.
     */

    PREFERRED_STOCK("PreferredStock"),

    /**
     * Use Prepaid Expenses to track payments for expenses that you won't recognize
     * until your next accounting period. When you recognize the expense, make a
     * journal entry to transfer money from this account to the expense account.
     */

    PREPAID_EXPENSES("PrepaidExpenses"),

    /**
     * Use Prepaid Expenses Payable to track items such as property taxes that are
     * due, but not yet deductible as an expense because the period they cover has
     * not yet passed.
     */

    PREPAID_EXPENSES_PAYABLE("PrepaidExpensesPayable"),

    /**
     * Use Promotional Meals to track how much you spend dining with a customer to
     * promote your business. Be sure to include who you ate with and the purpose of
     * the meal when you enter the transaction.
     */

    PROMOTIONAL_MEALS("PromotionalMeals"),

    /**
     * Use Rent or Lease of Buildings to track rent payments you make.
     */

    RENT_OR_LEASE_OF_BUILDINGS("RentOrLeaseOfBuildings"),

    /**
     * Use Rents Held in Trust to track deposits and rent held on behalf of the
     * property owners. Typically only property managers use this type of account.
     */

    RENTS_HELD_IN_TRUST("RentsHeldInTrust"),

    /**
     * Use Rents In Trust - Liability to offset the Rents in Trust amount in assets.
     * Amounts in these accounts are held by your business on behalf of others. They
     * do not belong to your business, so should not appear to be yours on your
     * balance sheet. This "contra" account takes care of that, as long as the two
     * balances match.
     */

    RENTS_IN_TRUST_LIABILITY("RentsInTrustLiability"),

    /**
     * Use Repair and Maintenance to track any repairs and periodic maintenance fees.
     * You may want different accounts of this type to track different types repair
     * and maintenance expenses (auto, equipment, landscape, and so on).
     */

    REPAIR_MAINTENANCE("RepairMaintenance"),

    /**
     * Use Retainage if your customers regularly hold back a portion of a contract
     * amount until you have completed a project. This type of account is often used
     * in the construction industry, and only if you record income on an accrual
     * basis.
     */

    RETAINAGE("Retainage"),

    /**
     * QBO adds this account when you create your company. Retained Earnings tracks
     * net income from previous fiscal years. QBO automatically transfers your profit
     * (or loss) to Retained Earnings at the end of each fiscal year.
     */

    RETAINED_EARNINGS("RetainedEarnings"),

    /**
     * Use Sales of Product Income to track income from selling products. This is
     * broadly construed to include all kinds of products, like crops and livestock,
     * rental fees, performances, and food served.
     */

    SALES_OF_PRODUCT_INCOME("SalesOfProductIncome"),

    /**
     * Use Sales Tax Payable to track sales tax you have collected, but not yet
     * remitted to the government agency.
     */

    SALES_TAX_PAYABLE("SalesTaxPayable"),

    /**
     * Use Savings Accounts to track savings and CD activity.
     */

    SAVINGS("Savings"),

    /**
     * Use Security Deposits to track funds you've paid to cover any potential costs
     * incurred by damage, loss, or theft. The funds should be returned to you at the
     * end of the contract. If you collect deposits, use an Other Current Liabilities
     * account type.
     */

    SECURITY_DEPOSITS("SecurityDeposits"),

    /**
     * Use Service/Fee Income to track income from services you perform or ordinary
     * usage fees you charge. For fees customers pay you for late payments or other
     * uncommon situations, use an Other Income account type called Other
     * Miscellaneous Income, instead.
     */

    SERVICE_FEE_INCOME("ServiceFeeIncome"),

    /**
     * Use Shareholder Notes Payable to track long-term loan balances your business
     * owes its shareholders.
     */

    SHAREHOLDER_NOTES_PAYABLE("ShareholderNotesPayable"),

    /**
     * Use Shipping, Freight and Delivery to track the cost of shipping products to
     * customers or distributors.
     */

    SHIPPING_FREIGHT_DELIVERY("ShippingFreightDelivery"),

    /**
     * Use Shipping, Freight and Delivery to track the cost of shipping products to
     * customers or distributors.
     */

    SHIPPING_FREIGHT_DELIVERY_COS("ShippingFreightDeliveryCos"),

    /**
     * Use State/Local Income Tax Payable if your business is a corporation, S
     * corporation, or limited partnership keeping records on the accrual basis. This
     * account tracks income tax liabilities in the year the income is earned.
     */

    STATE_LOCAL_INCOME_TAX_PAYABLE("StateLocalIncomeTaxPayable"),

    /**
     * Use Supplies and Materials to track the cost of raw goods and parts used or
     * consumed when producing a product or providing a service.
     */

    SUPPLIES_MATERIALS("SuppliesMaterials"),

    /**
     * Use Supplies and Materials to track the cost of raw goods and parts used or
     * consumed when producing a product or providing a service.
     */

    SUPPLIES_MATERIALS_COGS("SuppliesMaterialsCogs"),

    /**
     * Use Taxes Paid to track taxes you pay. You may want different accounts of this
     * type for payments to different tax agencies (sales tax, state tax, federal
     * tax).
     */

    TAXES_PAID("TaxesPaid"),

    /**
     * Use Tax-Exempt Interest to record interest that isn't taxable, such as
     * interest on money in tax-exempt retirement accounts, or interest from
     * tax-exempt bonds.
     */

    TAX_EXEMPT_INTEREST("TaxExemptInterest"),

    /**
     * Use Travel to track travel costs. For food you eat while travelling, use
     * Travel Meals, instead.
     */

    TRAVEL("Travel"),

    /**
     * Use Travel Meals to track how much you spend on food while traveling. If you
     * dine with a customer to promote your business, use a Promotional Meals
     * account, instead. If you dine with your employees to promote morale, use
     * Entertainment Meals, instead.
     */

    TRAVEL_MEALS("TravelMeals"),

    /**
     * Corporations use Treasury Stock to track amounts paid by the corporation to
     * buy its own stock back from shareholders.
     */

    TREASURY_STOCK("TreasuryStock"),

    /**
     * Use Trust Accounts for money held by you for the benefit of someone else. For
     * example, Trust accounts are often used by attorneys to keep track of expense
     * money their customers have given them. Often, to keep the amount in a Trust
     * account from looking like it's yours, the amount is offset in a "contra"
     * liability account (a Current Liability).
     */

    TRUST_ACCOUNTS("TrustAccounts"),

    /**
     * Use Trust Accounts - Liabilities to offset Trust Accounts in assets. Amounts
     * in these accounts are held by your business on behalf of others. They do not
     * belong to your business, so should not appear to be yours on your balance
     * sheet. This "contra" account takes care of that, as long as the two balances
     * match.
     */

    TRUST_ACCOUNTS_LIABILITIES("TrustAccountsLiabilities"),

    /**
     * Use Undeposited Funds for cash or checks from sales that haven't been
     * deposited yet.
     */

    UNDEPOSITED_FUNDS("UndepositedFunds"),

    /**
     * Use Utilities to track utility payments. You may want different accounts of
     * this type to track different types of utility payments (gas and electric,
     * telephone, water, and so on).
     */

    UTILITIES("Utilities"),

    /**
     * Use Vehicles to track the value of vehicles your business owns and uses for
     * business. This includes off-road vehicles, air planes, helicopters, and boats.
     * If you use a vehicle for both business and personal use, consult your
     * accountant or the IRS to see how you should track its value.
     */

    VEHICLES("Vehicles");

    private final String value;

    AccountOnlineDetail(String v)
    {
        value = v;
    }

    public QboAccountDetailTypeEnum toQboAccountDetail()
    {
        return QboAccountDetailTypeEnum.fromValue(value);
    }

}
