
package org.mule.modules.quickbooks.online.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.modules.quickbooks.online.processors.UpdateCreditCardChargeMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class UpdateCreditCardChargeDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public UpdateCreditCardChargeDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(UpdateCreditCardChargeMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("realmId")!= null)&&(!StringUtils.isBlank(element.getAttribute("realmId")))) {
            builder.addPropertyValue("realmId", element.getAttribute("realmId"));
        }
        if ((element.getAttribute("appKey")!= null)&&(!StringUtils.isBlank(element.getAttribute("appKey")))) {
            builder.addPropertyValue("appKey", element.getAttribute("appKey"));
        }
        if ((element.getAttribute("realmIdPseudonym")!= null)&&(!StringUtils.isBlank(element.getAttribute("realmIdPseudonym")))) {
            builder.addPropertyValue("realmIdPseudonym", element.getAttribute("realmIdPseudonym"));
        }
        if ((element.getAttribute("authIdPseudonym")!= null)&&(!StringUtils.isBlank(element.getAttribute("authIdPseudonym")))) {
            builder.addPropertyValue("authIdPseudonym", element.getAttribute("authIdPseudonym"));
        }
        Element idListElement = null;
        idListElement = DomUtils.getChildElementByTagName(element, "id");
        List<Element> idMapChilds = null;
        if (idListElement!= null) {
            String idRef = idListElement.getAttribute("ref");
            if ((idRef!= null)&&(!StringUtils.isBlank(idRef))) {
                if ((!idRef.startsWith(patternInfo.getPrefix()))&&(!idRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("id", new RuntimeBeanReference(idRef));
                } else {
                    builder.addPropertyValue("id", idRef);
                }
            } else {
                ManagedMap id = new ManagedMap();
                idMapChilds = DomUtils.getChildElementsByTagName(idListElement, "id");
                if (idMapChilds!= null) {
                    if (idMapChilds.size() == 0) {
                        idMapChilds = DomUtils.getChildElements(idListElement);
                    }
                    for (Element idChild: idMapChilds) {
                        String idValueRef = idChild.getAttribute("value-ref");
                        String idKeyRef = idChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((idValueRef!= null)&&(!StringUtils.isBlank(idValueRef))) {
                            if ((!idValueRef.startsWith(patternInfo.getPrefix()))&&(!idValueRef.endsWith(patternInfo.getSuffix()))) {
                                valueObject = new RuntimeBeanReference(idValueRef);
                            } else {
                                valueObject = idValueRef;
                            }
                        } else {
                            valueObject = idChild.getTextContent();
                        }
                        if ((idKeyRef!= null)&&(!StringUtils.isBlank(idKeyRef))) {
                            keyObject = new RuntimeBeanReference(idKeyRef);
                        } else {
                            keyObject = idChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = idChild.getTagName();
                        }
                        id.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("id", id);
            }
        }
        if ((element.getAttribute("syncToken")!= null)&&(!StringUtils.isBlank(element.getAttribute("syncToken")))) {
            builder.addPropertyValue("syncToken", element.getAttribute("syncToken"));
        }
        Element headerListElement = null;
        headerListElement = DomUtils.getChildElementByTagName(element, "header");
        List<Element> headerMapChilds = null;
        if (headerListElement!= null) {
            String headerRef = headerListElement.getAttribute("ref");
            if ((headerRef!= null)&&(!StringUtils.isBlank(headerRef))) {
                if ((!headerRef.startsWith(patternInfo.getPrefix()))&&(!headerRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("header", new RuntimeBeanReference(headerRef));
                } else {
                    builder.addPropertyValue("header", headerRef);
                }
            } else {
                ManagedMap header = new ManagedMap();
                headerMapChilds = DomUtils.getChildElementsByTagName(headerListElement, "header");
                if (headerMapChilds!= null) {
                    if (headerMapChilds.size() == 0) {
                        headerMapChilds = DomUtils.getChildElements(headerListElement);
                    }
                    for (Element headerChild: headerMapChilds) {
                        String headerValueRef = headerChild.getAttribute("value-ref");
                        String headerKeyRef = headerChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((headerValueRef!= null)&&(!StringUtils.isBlank(headerValueRef))) {
                            if ((!headerValueRef.startsWith(patternInfo.getPrefix()))&&(!headerValueRef.endsWith(patternInfo.getSuffix()))) {
                                valueObject = new RuntimeBeanReference(headerValueRef);
                            } else {
                                valueObject = headerValueRef;
                            }
                        } else {
                            valueObject = headerChild.getTextContent();
                        }
                        if ((headerKeyRef!= null)&&(!StringUtils.isBlank(headerKeyRef))) {
                            keyObject = new RuntimeBeanReference(headerKeyRef);
                        } else {
                            keyObject = headerChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = headerChild.getTagName();
                        }
                        header.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("header", header);
            }
        }
        Element linesListElement = null;
        linesListElement = DomUtils.getChildElementByTagName(element, "lines");
        List<Element> linesListChilds = null;
        if (linesListElement!= null) {
            String linesRef = linesListElement.getAttribute("ref");
            if ((linesRef!= null)&&(!StringUtils.isBlank(linesRef))) {
                if ((!linesRef.startsWith(patternInfo.getPrefix()))&&(!linesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("lines", new RuntimeBeanReference(linesRef));
                } else {
                    builder.addPropertyValue("lines", linesRef);
                }
            } else {
                ManagedList lines = new ManagedList();
                linesListChilds = DomUtils.getChildElementsByTagName(linesListElement, "line");
                if (linesListChilds!= null) {
                    for (Element linesChild: linesListChilds) {
                        String valueRef = linesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            if ((!valueRef.startsWith(patternInfo.getPrefix()))&&(!valueRef.endsWith(patternInfo.getSuffix()))) {
                                lines.add(new RuntimeBeanReference(valueRef));
                            } else {
                                lines.add(valueRef);
                            }
                        } else {
                            List<Element> innerlineMapChilds = null;
                            if (linesChild!= null) {
                                String innerlineRef = linesChild.getAttribute("ref");
                                if ((innerlineRef!= null)&&(!StringUtils.isBlank(innerlineRef))) {
                                    if ((!innerlineRef.startsWith(patternInfo.getPrefix()))&&(!innerlineRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-line", new RuntimeBeanReference(innerlineRef));
                                    } else {
                                        builder.addPropertyValue("inner-line", innerlineRef);
                                    }
                                } else {
                                    ManagedMap innerline = new ManagedMap();
                                    innerlineMapChilds = DomUtils.getChildElementsByTagName(linesChild, "inner-line");
                                    if (innerlineMapChilds!= null) {
                                        if (innerlineMapChilds.size() == 0) {
                                            innerlineMapChilds = DomUtils.getChildElements(linesChild);
                                        }
                                        for (Element innerlineChild: innerlineMapChilds) {
                                            String innerlineValueRef = innerlineChild.getAttribute("value-ref");
                                            String innerlineKeyRef = innerlineChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innerlineValueRef!= null)&&(!StringUtils.isBlank(innerlineValueRef))) {
                                                if ((!innerlineValueRef.startsWith(patternInfo.getPrefix()))&&(!innerlineValueRef.endsWith(patternInfo.getSuffix()))) {
                                                    valueObject = new RuntimeBeanReference(innerlineValueRef);
                                                } else {
                                                    valueObject = innerlineValueRef;
                                                }
                                            } else {
                                                valueObject = innerlineChild.getTextContent();
                                            }
                                            if ((innerlineKeyRef!= null)&&(!StringUtils.isBlank(innerlineKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innerlineKeyRef);
                                            } else {
                                                keyObject = innerlineChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innerlineChild.getTagName();
                                            }
                                            innerline.put(keyObject, valueObject);
                                        }
                                    }
                                    lines.add(innerline);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("lines", lines);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
