
package org.mule.modules.quickbooks.online.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.modules.quickbooks.online.processors.UpdateAccountMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class UpdateAccountDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public UpdateAccountDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(UpdateAccountMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("realmId")!= null)&&(!StringUtils.isBlank(element.getAttribute("realmId")))) {
            builder.addPropertyValue("realmId", element.getAttribute("realmId"));
        }
        if ((element.getAttribute("appKey")!= null)&&(!StringUtils.isBlank(element.getAttribute("appKey")))) {
            builder.addPropertyValue("appKey", element.getAttribute("appKey"));
        }
        if ((element.getAttribute("realmIdPseudonym")!= null)&&(!StringUtils.isBlank(element.getAttribute("realmIdPseudonym")))) {
            builder.addPropertyValue("realmIdPseudonym", element.getAttribute("realmIdPseudonym"));
        }
        if ((element.getAttribute("authIdPseudonym")!= null)&&(!StringUtils.isBlank(element.getAttribute("authIdPseudonym")))) {
            builder.addPropertyValue("authIdPseudonym", element.getAttribute("authIdPseudonym"));
        }
        Element idListElement = null;
        idListElement = DomUtils.getChildElementByTagName(element, "id");
        List<Element> idMapChilds = null;
        if (idListElement!= null) {
            String idRef = idListElement.getAttribute("ref");
            if ((idRef!= null)&&(!StringUtils.isBlank(idRef))) {
                if ((!idRef.startsWith(patternInfo.getPrefix()))&&(!idRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("id", new RuntimeBeanReference(idRef));
                } else {
                    builder.addPropertyValue("id", idRef);
                }
            } else {
                ManagedMap id = new ManagedMap();
                idMapChilds = DomUtils.getChildElementsByTagName(idListElement, "id");
                if (idMapChilds!= null) {
                    if (idMapChilds.size() == 0) {
                        idMapChilds = DomUtils.getChildElements(idListElement);
                    }
                    for (Element idChild: idMapChilds) {
                        String idValueRef = idChild.getAttribute("value-ref");
                        String idKeyRef = idChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((idValueRef!= null)&&(!StringUtils.isBlank(idValueRef))) {
                            if ((!idValueRef.startsWith(patternInfo.getPrefix()))&&(!idValueRef.endsWith(patternInfo.getSuffix()))) {
                                valueObject = new RuntimeBeanReference(idValueRef);
                            } else {
                                valueObject = idValueRef;
                            }
                        } else {
                            valueObject = idChild.getTextContent();
                        }
                        if ((idKeyRef!= null)&&(!StringUtils.isBlank(idKeyRef))) {
                            keyObject = new RuntimeBeanReference(idKeyRef);
                        } else {
                            keyObject = idChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = idChild.getTagName();
                        }
                        id.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("id", id);
            }
        }
        if ((element.getAttribute("syncToken")!= null)&&(!StringUtils.isBlank(element.getAttribute("syncToken")))) {
            builder.addPropertyValue("syncToken", element.getAttribute("syncToken"));
        }
        if ((element.getAttribute("name")!= null)&&(!StringUtils.isBlank(element.getAttribute("name")))) {
            builder.addPropertyValue("name", element.getAttribute("name"));
        }
        if ((element.getAttribute("desc")!= null)&&(!StringUtils.isBlank(element.getAttribute("desc")))) {
            builder.addPropertyValue("desc", element.getAttribute("desc"));
        }
        if (element.hasAttribute("subtype")) {
            builder.addPropertyValue("subtype", element.getAttribute("subtype"));
        }
        if ((element.getAttribute("acctNum")!= null)&&(!StringUtils.isBlank(element.getAttribute("acctNum")))) {
            builder.addPropertyValue("acctNum", element.getAttribute("acctNum"));
        }
        if ((element.getAttribute("openingBalance")!= null)&&(!StringUtils.isBlank(element.getAttribute("openingBalance")))) {
            builder.addPropertyValue("openingBalance", element.getAttribute("openingBalance"));
        }
        if ((element.getAttribute("openingBalanceDate")!= null)&&(!StringUtils.isBlank(element.getAttribute("openingBalanceDate")))) {
            builder.addPropertyValue("openingBalanceDate", element.getAttribute("openingBalanceDate"));
        }
        Element accountParentIdListElement = null;
        accountParentIdListElement = DomUtils.getChildElementByTagName(element, "account-parent-id");
        List<Element> accountParentIdMapChilds = null;
        if (accountParentIdListElement!= null) {
            String accountParentIdRef = accountParentIdListElement.getAttribute("ref");
            if ((accountParentIdRef!= null)&&(!StringUtils.isBlank(accountParentIdRef))) {
                if ((!accountParentIdRef.startsWith(patternInfo.getPrefix()))&&(!accountParentIdRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("accountParentId", new RuntimeBeanReference(accountParentIdRef));
                } else {
                    builder.addPropertyValue("accountParentId", accountParentIdRef);
                }
            } else {
                ManagedMap accountParentId = new ManagedMap();
                accountParentIdMapChilds = DomUtils.getChildElementsByTagName(accountParentIdListElement, "account-parent-id");
                if (accountParentIdMapChilds!= null) {
                    if (accountParentIdMapChilds.size() == 0) {
                        accountParentIdMapChilds = DomUtils.getChildElements(accountParentIdListElement);
                    }
                    for (Element accountParentIdChild: accountParentIdMapChilds) {
                        String accountParentIdValueRef = accountParentIdChild.getAttribute("value-ref");
                        String accountParentIdKeyRef = accountParentIdChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((accountParentIdValueRef!= null)&&(!StringUtils.isBlank(accountParentIdValueRef))) {
                            if ((!accountParentIdValueRef.startsWith(patternInfo.getPrefix()))&&(!accountParentIdValueRef.endsWith(patternInfo.getSuffix()))) {
                                valueObject = new RuntimeBeanReference(accountParentIdValueRef);
                            } else {
                                valueObject = accountParentIdValueRef;
                            }
                        } else {
                            valueObject = accountParentIdChild.getTextContent();
                        }
                        if ((accountParentIdKeyRef!= null)&&(!StringUtils.isBlank(accountParentIdKeyRef))) {
                            keyObject = new RuntimeBeanReference(accountParentIdKeyRef);
                        } else {
                            keyObject = accountParentIdChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = accountParentIdChild.getTagName();
                        }
                        accountParentId.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("accountParentId", accountParentId);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
