
package org.mule.modules.quickbooks.online.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.modules.quickbooks.online.processors.CreateCustomerMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateCustomerDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public CreateCustomerDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CreateCustomerMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("realmId")!= null)&&(!StringUtils.isBlank(element.getAttribute("realmId")))) {
            builder.addPropertyValue("realmId", element.getAttribute("realmId"));
        }
        if ((element.getAttribute("appKey")!= null)&&(!StringUtils.isBlank(element.getAttribute("appKey")))) {
            builder.addPropertyValue("appKey", element.getAttribute("appKey"));
        }
        if ((element.getAttribute("realmIdPseudonym")!= null)&&(!StringUtils.isBlank(element.getAttribute("realmIdPseudonym")))) {
            builder.addPropertyValue("realmIdPseudonym", element.getAttribute("realmIdPseudonym"));
        }
        if ((element.getAttribute("authIdPseudonym")!= null)&&(!StringUtils.isBlank(element.getAttribute("authIdPseudonym")))) {
            builder.addPropertyValue("authIdPseudonym", element.getAttribute("authIdPseudonym"));
        }
        if ((element.getAttribute("name")!= null)&&(!StringUtils.isBlank(element.getAttribute("name")))) {
            builder.addPropertyValue("name", element.getAttribute("name"));
        }
        if ((element.getAttribute("givenName")!= null)&&(!StringUtils.isBlank(element.getAttribute("givenName")))) {
            builder.addPropertyValue("givenName", element.getAttribute("givenName"));
        }
        if ((element.getAttribute("middleName")!= null)&&(!StringUtils.isBlank(element.getAttribute("middleName")))) {
            builder.addPropertyValue("middleName", element.getAttribute("middleName"));
        }
        if ((element.getAttribute("familyName")!= null)&&(!StringUtils.isBlank(element.getAttribute("familyName")))) {
            builder.addPropertyValue("familyName", element.getAttribute("familyName"));
        }
        if ((element.getAttribute("suffix")!= null)&&(!StringUtils.isBlank(element.getAttribute("suffix")))) {
            builder.addPropertyValue("suffix", element.getAttribute("suffix"));
        }
        if ((element.getAttribute("dBAName")!= null)&&(!StringUtils.isBlank(element.getAttribute("dBAName")))) {
            builder.addPropertyValue("dBAName", element.getAttribute("dBAName"));
        }
        if ((element.getAttribute("showAs")!= null)&&(!StringUtils.isBlank(element.getAttribute("showAs")))) {
            builder.addPropertyValue("showAs", element.getAttribute("showAs"));
        }
        Element webSitesListElement = null;
        webSitesListElement = DomUtils.getChildElementByTagName(element, "web-sites");
        List<Element> webSitesListChilds = null;
        if (webSitesListElement!= null) {
            String webSitesRef = webSitesListElement.getAttribute("ref");
            if ((webSitesRef!= null)&&(!StringUtils.isBlank(webSitesRef))) {
                if ((!webSitesRef.startsWith(patternInfo.getPrefix()))&&(!webSitesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("webSites", new RuntimeBeanReference(webSitesRef));
                } else {
                    builder.addPropertyValue("webSites", webSitesRef);
                }
            } else {
                ManagedList webSites = new ManagedList();
                webSitesListChilds = DomUtils.getChildElementsByTagName(webSitesListElement, "web-site");
                if (webSitesListChilds!= null) {
                    for (Element webSitesChild: webSitesListChilds) {
                        String valueRef = webSitesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            if ((!valueRef.startsWith(patternInfo.getPrefix()))&&(!valueRef.endsWith(patternInfo.getSuffix()))) {
                                webSites.add(new RuntimeBeanReference(valueRef));
                            } else {
                                webSites.add(valueRef);
                            }
                        } else {
                            List<Element> innerwebsiteMapChilds = null;
                            if (webSitesChild!= null) {
                                String innerwebsiteRef = webSitesChild.getAttribute("ref");
                                if ((innerwebsiteRef!= null)&&(!StringUtils.isBlank(innerwebsiteRef))) {
                                    if ((!innerwebsiteRef.startsWith(patternInfo.getPrefix()))&&(!innerwebsiteRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-web-site", new RuntimeBeanReference(innerwebsiteRef));
                                    } else {
                                        builder.addPropertyValue("inner-web-site", innerwebsiteRef);
                                    }
                                } else {
                                    ManagedMap innerwebsite = new ManagedMap();
                                    innerwebsiteMapChilds = DomUtils.getChildElementsByTagName(webSitesChild, "inner-web-site");
                                    if (innerwebsiteMapChilds!= null) {
                                        if (innerwebsiteMapChilds.size() == 0) {
                                            innerwebsiteMapChilds = DomUtils.getChildElements(webSitesChild);
                                        }
                                        for (Element innerwebsiteChild: innerwebsiteMapChilds) {
                                            String innerwebsiteValueRef = innerwebsiteChild.getAttribute("value-ref");
                                            String innerwebsiteKeyRef = innerwebsiteChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innerwebsiteValueRef!= null)&&(!StringUtils.isBlank(innerwebsiteValueRef))) {
                                                if ((!innerwebsiteValueRef.startsWith(patternInfo.getPrefix()))&&(!innerwebsiteValueRef.endsWith(patternInfo.getSuffix()))) {
                                                    valueObject = new RuntimeBeanReference(innerwebsiteValueRef);
                                                } else {
                                                    valueObject = innerwebsiteValueRef;
                                                }
                                            } else {
                                                valueObject = innerwebsiteChild.getTextContent();
                                            }
                                            if ((innerwebsiteKeyRef!= null)&&(!StringUtils.isBlank(innerwebsiteKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innerwebsiteKeyRef);
                                            } else {
                                                keyObject = innerwebsiteChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innerwebsiteChild.getTagName();
                                            }
                                            innerwebsite.put(keyObject, valueObject);
                                        }
                                    }
                                    webSites.add(innerwebsite);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("webSites", webSites);
            }
        }
        Element salesTermIdListElement = null;
        salesTermIdListElement = DomUtils.getChildElementByTagName(element, "sales-term-id");
        List<Element> salesTermIdMapChilds = null;
        if (salesTermIdListElement!= null) {
            String salesTermIdRef = salesTermIdListElement.getAttribute("ref");
            if ((salesTermIdRef!= null)&&(!StringUtils.isBlank(salesTermIdRef))) {
                if ((!salesTermIdRef.startsWith(patternInfo.getPrefix()))&&(!salesTermIdRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("salesTermId", new RuntimeBeanReference(salesTermIdRef));
                } else {
                    builder.addPropertyValue("salesTermId", salesTermIdRef);
                }
            } else {
                ManagedMap salesTermId = new ManagedMap();
                salesTermIdMapChilds = DomUtils.getChildElementsByTagName(salesTermIdListElement, "sales-term-id");
                if (salesTermIdMapChilds!= null) {
                    if (salesTermIdMapChilds.size() == 0) {
                        salesTermIdMapChilds = DomUtils.getChildElements(salesTermIdListElement);
                    }
                    for (Element salesTermIdChild: salesTermIdMapChilds) {
                        String salesTermIdValueRef = salesTermIdChild.getAttribute("value-ref");
                        String salesTermIdKeyRef = salesTermIdChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((salesTermIdValueRef!= null)&&(!StringUtils.isBlank(salesTermIdValueRef))) {
                            if ((!salesTermIdValueRef.startsWith(patternInfo.getPrefix()))&&(!salesTermIdValueRef.endsWith(patternInfo.getSuffix()))) {
                                valueObject = new RuntimeBeanReference(salesTermIdValueRef);
                            } else {
                                valueObject = salesTermIdValueRef;
                            }
                        } else {
                            valueObject = salesTermIdChild.getTextContent();
                        }
                        if ((salesTermIdKeyRef!= null)&&(!StringUtils.isBlank(salesTermIdKeyRef))) {
                            keyObject = new RuntimeBeanReference(salesTermIdKeyRef);
                        } else {
                            keyObject = salesTermIdChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = salesTermIdChild.getTagName();
                        }
                        salesTermId.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("salesTermId", salesTermId);
            }
        }
        Element paymentMethodIdListElement = null;
        paymentMethodIdListElement = DomUtils.getChildElementByTagName(element, "payment-method-id");
        List<Element> paymentMethodIdMapChilds = null;
        if (paymentMethodIdListElement!= null) {
            String paymentMethodIdRef = paymentMethodIdListElement.getAttribute("ref");
            if ((paymentMethodIdRef!= null)&&(!StringUtils.isBlank(paymentMethodIdRef))) {
                if ((!paymentMethodIdRef.startsWith(patternInfo.getPrefix()))&&(!paymentMethodIdRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("paymentMethodId", new RuntimeBeanReference(paymentMethodIdRef));
                } else {
                    builder.addPropertyValue("paymentMethodId", paymentMethodIdRef);
                }
            } else {
                ManagedMap paymentMethodId = new ManagedMap();
                paymentMethodIdMapChilds = DomUtils.getChildElementsByTagName(paymentMethodIdListElement, "payment-method-id");
                if (paymentMethodIdMapChilds!= null) {
                    if (paymentMethodIdMapChilds.size() == 0) {
                        paymentMethodIdMapChilds = DomUtils.getChildElements(paymentMethodIdListElement);
                    }
                    for (Element paymentMethodIdChild: paymentMethodIdMapChilds) {
                        String paymentMethodIdValueRef = paymentMethodIdChild.getAttribute("value-ref");
                        String paymentMethodIdKeyRef = paymentMethodIdChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((paymentMethodIdValueRef!= null)&&(!StringUtils.isBlank(paymentMethodIdValueRef))) {
                            if ((!paymentMethodIdValueRef.startsWith(patternInfo.getPrefix()))&&(!paymentMethodIdValueRef.endsWith(patternInfo.getSuffix()))) {
                                valueObject = new RuntimeBeanReference(paymentMethodIdValueRef);
                            } else {
                                valueObject = paymentMethodIdValueRef;
                            }
                        } else {
                            valueObject = paymentMethodIdChild.getTextContent();
                        }
                        if ((paymentMethodIdKeyRef!= null)&&(!StringUtils.isBlank(paymentMethodIdKeyRef))) {
                            keyObject = new RuntimeBeanReference(paymentMethodIdKeyRef);
                        } else {
                            keyObject = paymentMethodIdChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = paymentMethodIdChild.getTagName();
                        }
                        paymentMethodId.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("paymentMethodId", paymentMethodId);
            }
        }
        Element salesTaxCodeIdListElement = null;
        salesTaxCodeIdListElement = DomUtils.getChildElementByTagName(element, "sales-tax-code-id");
        List<Element> salesTaxCodeIdMapChilds = null;
        if (salesTaxCodeIdListElement!= null) {
            String salesTaxCodeIdRef = salesTaxCodeIdListElement.getAttribute("ref");
            if ((salesTaxCodeIdRef!= null)&&(!StringUtils.isBlank(salesTaxCodeIdRef))) {
                if ((!salesTaxCodeIdRef.startsWith(patternInfo.getPrefix()))&&(!salesTaxCodeIdRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("salesTaxCodeId", new RuntimeBeanReference(salesTaxCodeIdRef));
                } else {
                    builder.addPropertyValue("salesTaxCodeId", salesTaxCodeIdRef);
                }
            } else {
                ManagedMap salesTaxCodeId = new ManagedMap();
                salesTaxCodeIdMapChilds = DomUtils.getChildElementsByTagName(salesTaxCodeIdListElement, "sales-tax-code-id");
                if (salesTaxCodeIdMapChilds!= null) {
                    if (salesTaxCodeIdMapChilds.size() == 0) {
                        salesTaxCodeIdMapChilds = DomUtils.getChildElements(salesTaxCodeIdListElement);
                    }
                    for (Element salesTaxCodeIdChild: salesTaxCodeIdMapChilds) {
                        String salesTaxCodeIdValueRef = salesTaxCodeIdChild.getAttribute("value-ref");
                        String salesTaxCodeIdKeyRef = salesTaxCodeIdChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((salesTaxCodeIdValueRef!= null)&&(!StringUtils.isBlank(salesTaxCodeIdValueRef))) {
                            if ((!salesTaxCodeIdValueRef.startsWith(patternInfo.getPrefix()))&&(!salesTaxCodeIdValueRef.endsWith(patternInfo.getSuffix()))) {
                                valueObject = new RuntimeBeanReference(salesTaxCodeIdValueRef);
                            } else {
                                valueObject = salesTaxCodeIdValueRef;
                            }
                        } else {
                            valueObject = salesTaxCodeIdChild.getTextContent();
                        }
                        if ((salesTaxCodeIdKeyRef!= null)&&(!StringUtils.isBlank(salesTaxCodeIdKeyRef))) {
                            keyObject = new RuntimeBeanReference(salesTaxCodeIdKeyRef);
                        } else {
                            keyObject = salesTaxCodeIdChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = salesTaxCodeIdChild.getTagName();
                        }
                        salesTaxCodeId.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("salesTaxCodeId", salesTaxCodeId);
            }
        }
        Element emailsListElement = null;
        emailsListElement = DomUtils.getChildElementByTagName(element, "emails");
        List<Element> emailsListChilds = null;
        if (emailsListElement!= null) {
            String emailsRef = emailsListElement.getAttribute("ref");
            if ((emailsRef!= null)&&(!StringUtils.isBlank(emailsRef))) {
                if ((!emailsRef.startsWith(patternInfo.getPrefix()))&&(!emailsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("emails", new RuntimeBeanReference(emailsRef));
                } else {
                    builder.addPropertyValue("emails", emailsRef);
                }
            } else {
                ManagedList emails = new ManagedList();
                emailsListChilds = DomUtils.getChildElementsByTagName(emailsListElement, "email");
                if (emailsListChilds!= null) {
                    for (Element emailsChild: emailsListChilds) {
                        String valueRef = emailsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            if ((!valueRef.startsWith(patternInfo.getPrefix()))&&(!valueRef.endsWith(patternInfo.getSuffix()))) {
                                emails.add(new RuntimeBeanReference(valueRef));
                            } else {
                                emails.add(valueRef);
                            }
                        } else {
                            List<Element> inneremailMapChilds = null;
                            if (emailsChild!= null) {
                                String inneremailRef = emailsChild.getAttribute("ref");
                                if ((inneremailRef!= null)&&(!StringUtils.isBlank(inneremailRef))) {
                                    if ((!inneremailRef.startsWith(patternInfo.getPrefix()))&&(!inneremailRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-email", new RuntimeBeanReference(inneremailRef));
                                    } else {
                                        builder.addPropertyValue("inner-email", inneremailRef);
                                    }
                                } else {
                                    ManagedMap inneremail = new ManagedMap();
                                    inneremailMapChilds = DomUtils.getChildElementsByTagName(emailsChild, "inner-email");
                                    if (inneremailMapChilds!= null) {
                                        if (inneremailMapChilds.size() == 0) {
                                            inneremailMapChilds = DomUtils.getChildElements(emailsChild);
                                        }
                                        for (Element inneremailChild: inneremailMapChilds) {
                                            String inneremailValueRef = inneremailChild.getAttribute("value-ref");
                                            String inneremailKeyRef = inneremailChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((inneremailValueRef!= null)&&(!StringUtils.isBlank(inneremailValueRef))) {
                                                if ((!inneremailValueRef.startsWith(patternInfo.getPrefix()))&&(!inneremailValueRef.endsWith(patternInfo.getSuffix()))) {
                                                    valueObject = new RuntimeBeanReference(inneremailValueRef);
                                                } else {
                                                    valueObject = inneremailValueRef;
                                                }
                                            } else {
                                                valueObject = inneremailChild.getTextContent();
                                            }
                                            if ((inneremailKeyRef!= null)&&(!StringUtils.isBlank(inneremailKeyRef))) {
                                                keyObject = new RuntimeBeanReference(inneremailKeyRef);
                                            } else {
                                                keyObject = inneremailChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = inneremailChild.getTagName();
                                            }
                                            inneremail.put(keyObject, valueObject);
                                        }
                                    }
                                    emails.add(inneremail);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("emails", emails);
            }
        }
        Element phonesListElement = null;
        phonesListElement = DomUtils.getChildElementByTagName(element, "phones");
        List<Element> phonesListChilds = null;
        if (phonesListElement!= null) {
            String phonesRef = phonesListElement.getAttribute("ref");
            if ((phonesRef!= null)&&(!StringUtils.isBlank(phonesRef))) {
                if ((!phonesRef.startsWith(patternInfo.getPrefix()))&&(!phonesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("phones", new RuntimeBeanReference(phonesRef));
                } else {
                    builder.addPropertyValue("phones", phonesRef);
                }
            } else {
                ManagedList phones = new ManagedList();
                phonesListChilds = DomUtils.getChildElementsByTagName(phonesListElement, "phone");
                if (phonesListChilds!= null) {
                    for (Element phonesChild: phonesListChilds) {
                        String valueRef = phonesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            if ((!valueRef.startsWith(patternInfo.getPrefix()))&&(!valueRef.endsWith(patternInfo.getSuffix()))) {
                                phones.add(new RuntimeBeanReference(valueRef));
                            } else {
                                phones.add(valueRef);
                            }
                        } else {
                            List<Element> innerphoneMapChilds = null;
                            if (phonesChild!= null) {
                                String innerphoneRef = phonesChild.getAttribute("ref");
                                if ((innerphoneRef!= null)&&(!StringUtils.isBlank(innerphoneRef))) {
                                    if ((!innerphoneRef.startsWith(patternInfo.getPrefix()))&&(!innerphoneRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-phone", new RuntimeBeanReference(innerphoneRef));
                                    } else {
                                        builder.addPropertyValue("inner-phone", innerphoneRef);
                                    }
                                } else {
                                    ManagedMap innerphone = new ManagedMap();
                                    innerphoneMapChilds = DomUtils.getChildElementsByTagName(phonesChild, "inner-phone");
                                    if (innerphoneMapChilds!= null) {
                                        if (innerphoneMapChilds.size() == 0) {
                                            innerphoneMapChilds = DomUtils.getChildElements(phonesChild);
                                        }
                                        for (Element innerphoneChild: innerphoneMapChilds) {
                                            String innerphoneValueRef = innerphoneChild.getAttribute("value-ref");
                                            String innerphoneKeyRef = innerphoneChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innerphoneValueRef!= null)&&(!StringUtils.isBlank(innerphoneValueRef))) {
                                                if ((!innerphoneValueRef.startsWith(patternInfo.getPrefix()))&&(!innerphoneValueRef.endsWith(patternInfo.getSuffix()))) {
                                                    valueObject = new RuntimeBeanReference(innerphoneValueRef);
                                                } else {
                                                    valueObject = innerphoneValueRef;
                                                }
                                            } else {
                                                valueObject = innerphoneChild.getTextContent();
                                            }
                                            if ((innerphoneKeyRef!= null)&&(!StringUtils.isBlank(innerphoneKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innerphoneKeyRef);
                                            } else {
                                                keyObject = innerphoneChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innerphoneChild.getTagName();
                                            }
                                            innerphone.put(keyObject, valueObject);
                                        }
                                    }
                                    phones.add(innerphone);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("phones", phones);
            }
        }
        Element addressesListElement = null;
        addressesListElement = DomUtils.getChildElementByTagName(element, "addresses");
        List<Element> addressesListChilds = null;
        if (addressesListElement!= null) {
            String addressesRef = addressesListElement.getAttribute("ref");
            if ((addressesRef!= null)&&(!StringUtils.isBlank(addressesRef))) {
                if ((!addressesRef.startsWith(patternInfo.getPrefix()))&&(!addressesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("addresses", new RuntimeBeanReference(addressesRef));
                } else {
                    builder.addPropertyValue("addresses", addressesRef);
                }
            } else {
                ManagedList addresses = new ManagedList();
                addressesListChilds = DomUtils.getChildElementsByTagName(addressesListElement, "address");
                if (addressesListChilds!= null) {
                    for (Element addressesChild: addressesListChilds) {
                        String valueRef = addressesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            if ((!valueRef.startsWith(patternInfo.getPrefix()))&&(!valueRef.endsWith(patternInfo.getSuffix()))) {
                                addresses.add(new RuntimeBeanReference(valueRef));
                            } else {
                                addresses.add(valueRef);
                            }
                        } else {
                            List<Element> inneraddressMapChilds = null;
                            if (addressesChild!= null) {
                                String inneraddressRef = addressesChild.getAttribute("ref");
                                if ((inneraddressRef!= null)&&(!StringUtils.isBlank(inneraddressRef))) {
                                    if ((!inneraddressRef.startsWith(patternInfo.getPrefix()))&&(!inneraddressRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-address", new RuntimeBeanReference(inneraddressRef));
                                    } else {
                                        builder.addPropertyValue("inner-address", inneraddressRef);
                                    }
                                } else {
                                    ManagedMap inneraddress = new ManagedMap();
                                    inneraddressMapChilds = DomUtils.getChildElementsByTagName(addressesChild, "inner-addres");
                                    if (inneraddressMapChilds!= null) {
                                        if (inneraddressMapChilds.size() == 0) {
                                            inneraddressMapChilds = DomUtils.getChildElements(addressesChild);
                                        }
                                        for (Element inneraddressChild: inneraddressMapChilds) {
                                            String inneraddressValueRef = inneraddressChild.getAttribute("value-ref");
                                            String inneraddressKeyRef = inneraddressChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((inneraddressValueRef!= null)&&(!StringUtils.isBlank(inneraddressValueRef))) {
                                                if ((!inneraddressValueRef.startsWith(patternInfo.getPrefix()))&&(!inneraddressValueRef.endsWith(patternInfo.getSuffix()))) {
                                                    valueObject = new RuntimeBeanReference(inneraddressValueRef);
                                                } else {
                                                    valueObject = inneraddressValueRef;
                                                }
                                            } else {
                                                valueObject = inneraddressChild.getTextContent();
                                            }
                                            if ((inneraddressKeyRef!= null)&&(!StringUtils.isBlank(inneraddressKeyRef))) {
                                                keyObject = new RuntimeBeanReference(inneraddressKeyRef);
                                            } else {
                                                keyObject = inneraddressChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = inneraddressChild.getTagName();
                                            }
                                            inneraddress.put(keyObject, valueObject);
                                        }
                                    }
                                    addresses.add(inneraddress);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("addresses", addresses);
            }
        }
        Element notesListElement = null;
        notesListElement = DomUtils.getChildElementByTagName(element, "notes");
        List<Element> notesListChilds = null;
        if (notesListElement!= null) {
            String notesRef = notesListElement.getAttribute("ref");
            if ((notesRef!= null)&&(!StringUtils.isBlank(notesRef))) {
                if ((!notesRef.startsWith(patternInfo.getPrefix()))&&(!notesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("notes", new RuntimeBeanReference(notesRef));
                } else {
                    builder.addPropertyValue("notes", notesRef);
                }
            } else {
                ManagedList notes = new ManagedList();
                notesListChilds = DomUtils.getChildElementsByTagName(notesListElement, "note");
                if (notesListChilds!= null) {
                    for (Element notesChild: notesListChilds) {
                        String valueRef = notesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            if ((!valueRef.startsWith(patternInfo.getPrefix()))&&(!valueRef.endsWith(patternInfo.getSuffix()))) {
                                notes.add(new RuntimeBeanReference(valueRef));
                            } else {
                                notes.add(valueRef);
                            }
                        } else {
                            List<Element> innernoteMapChilds = null;
                            if (notesChild!= null) {
                                String innernoteRef = notesChild.getAttribute("ref");
                                if ((innernoteRef!= null)&&(!StringUtils.isBlank(innernoteRef))) {
                                    if ((!innernoteRef.startsWith(patternInfo.getPrefix()))&&(!innernoteRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-note", new RuntimeBeanReference(innernoteRef));
                                    } else {
                                        builder.addPropertyValue("inner-note", innernoteRef);
                                    }
                                } else {
                                    ManagedMap innernote = new ManagedMap();
                                    innernoteMapChilds = DomUtils.getChildElementsByTagName(notesChild, "inner-note");
                                    if (innernoteMapChilds!= null) {
                                        if (innernoteMapChilds.size() == 0) {
                                            innernoteMapChilds = DomUtils.getChildElements(notesChild);
                                        }
                                        for (Element innernoteChild: innernoteMapChilds) {
                                            String innernoteValueRef = innernoteChild.getAttribute("value-ref");
                                            String innernoteKeyRef = innernoteChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innernoteValueRef!= null)&&(!StringUtils.isBlank(innernoteValueRef))) {
                                                if ((!innernoteValueRef.startsWith(patternInfo.getPrefix()))&&(!innernoteValueRef.endsWith(patternInfo.getSuffix()))) {
                                                    valueObject = new RuntimeBeanReference(innernoteValueRef);
                                                } else {
                                                    valueObject = innernoteValueRef;
                                                }
                                            } else {
                                                valueObject = innernoteChild.getTextContent();
                                            }
                                            if ((innernoteKeyRef!= null)&&(!StringUtils.isBlank(innernoteKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innernoteKeyRef);
                                            } else {
                                                keyObject = innernoteChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innernoteChild.getTagName();
                                            }
                                            innernote.put(keyObject, valueObject);
                                        }
                                    }
                                    notes.add(innernote);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("notes", notes);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
