
package org.mule.module.pubsubhubbub.config;

import org.apache.commons.lang.StringUtils;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.module.pubsubhubbub.adapters.PuSHSubscriberModuleLifecycleAdapter;
import org.mule.util.TemplateParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PuSHSubscriberModuleConfigDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public PuSHSubscriberModuleConfigDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        String name = element.getAttribute("name");
        if ((name == null)||StringUtils.isBlank(name)) {
            element.setAttribute("name", AutoIdUtils.getUniqueName(element, "mule-bean"));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(PuSHSubscriberModuleLifecycleAdapter.class.getName());
        if (Initialisable.class.isAssignableFrom(PuSHSubscriberModuleLifecycleAdapter.class)) {
            builder.setInitMethodName(Initialisable.PHASE_NAME);
        }
        if (Disposable.class.isAssignableFrom(PuSHSubscriberModuleLifecycleAdapter.class)) {
            builder.setDestroyMethodName(Disposable.PHASE_NAME);
        }
        if ((element.getAttribute("hubUrl")!= null)&&(!StringUtils.isBlank(element.getAttribute("hubUrl")))) {
            builder.addPropertyValue("hubUrl", element.getAttribute("hubUrl"));
        }
        if ((element.getAttribute("callbackUrl")!= null)&&(!StringUtils.isBlank(element.getAttribute("callbackUrl")))) {
            builder.addPropertyValue("callbackUrl", element.getAttribute("callbackUrl"));
        }
        if ((element.getAttribute("topic")!= null)&&(!StringUtils.isBlank(element.getAttribute("topic")))) {
            builder.addPropertyValue("topic", element.getAttribute("topic"));
        }
        if ((element.getAttribute("leaseSeconds")!= null)&&(!StringUtils.isBlank(element.getAttribute("leaseSeconds")))) {
            builder.addPropertyValue("leaseSeconds", element.getAttribute("leaseSeconds"));
        }
        if ((element.getAttribute("secret")!= null)&&(!StringUtils.isBlank(element.getAttribute("secret")))) {
            builder.addPropertyValue("secret", element.getAttribute("secret"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        return definition;
    }

}
