
package org.mule.module.pubsubhubbub.config;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/PuSH-subscriber</code>.
 * 
 */
public class PuSHSubscriberModuleNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new PuSHSubscriberModuleConfigDefinitionParser());
        registerBeanDefinitionParser("subscriber", new HandleSubscriberRequestDefinitionParser());
    }

}
