
package org.mule.module.pubsubhubbub.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.pubsubhubbub.config.HandleRequestMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HandleRequestDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public HandleRequestDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(HandleRequestMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", new RuntimeBeanReference(configRef));
        }
        if ((element.getAttribute("payload-ref")!= null)&&(!StringUtils.isBlank(element.getAttribute("payload-ref")))) {
            builder.addPropertyValue("payload", (("#[registry:"+ element.getAttribute("payload-ref"))+"]"));
        }
        Element responseHeadersListElement = null;
        responseHeadersListElement = DomUtils.getChildElementByTagName(element, "response-headers");
        List<Element> responseHeadersListChilds = null;
        if (responseHeadersListElement!= null) {
            String responseHeadersRef = responseHeadersListElement.getAttribute("ref");
            if ((responseHeadersRef!= null)&&(!StringUtils.isBlank(responseHeadersRef))) {
                if ((!responseHeadersRef.startsWith(patternInfo.getPrefix()))&&(!responseHeadersRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("responseHeaders", new RuntimeBeanReference(responseHeadersRef));
                } else {
                    builder.addPropertyValue("responseHeaders", responseHeadersRef);
                }
            } else {
                ManagedMap responseHeaders = new ManagedMap();
                responseHeadersListChilds = DomUtils.getChildElementsByTagName(responseHeadersListElement, "response-header");
                if (responseHeadersListChilds!= null) {
                    if (responseHeadersListChilds.size() == 0) {
                        responseHeadersListChilds = DomUtils.getChildElements(responseHeadersListElement);
                    }
                    for (Element responseHeadersChild: responseHeadersListChilds) {
                        String responseHeadersValueRef = responseHeadersChild.getAttribute("value-ref");
                        String responseHeadersKeyRef = responseHeadersChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((responseHeadersValueRef!= null)&&(!StringUtils.isBlank(responseHeadersValueRef))) {
                            valueObject = new RuntimeBeanReference(responseHeadersValueRef);
                        } else {
                            valueObject = responseHeadersChild.getTextContent();
                        }
                        if ((responseHeadersKeyRef!= null)&&(!StringUtils.isBlank(responseHeadersKeyRef))) {
                            keyObject = new RuntimeBeanReference(responseHeadersKeyRef);
                        } else {
                            keyObject = responseHeadersChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = responseHeadersChild.getTagName();
                        }
                        responseHeaders.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("responseHeaders", responseHeaders);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                propertyValues.addPropertyValue("messageProcessors", new ManagedList());
            }
            List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
            listMessageProcessors.add(definition);
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
