
package org.mule.module.pubsubhubbub.config.spring;

import org.apache.commons.lang.StringUtils;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.module.pubsubhubbub.config.HubModuleLifecycleAdapter;
import org.mule.util.TemplateParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class HubModuleConfigDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public HubModuleConfigDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        String name = element.getAttribute("name");
        if ((name == null)||StringUtils.isBlank(name)) {
            element.setAttribute("name", AutoIdUtils.getUniqueName(element, "mule-bean"));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(HubModuleLifecycleAdapter.class.getName());
        if (Initialisable.class.isAssignableFrom(HubModuleLifecycleAdapter.class)) {
            builder.setInitMethodName(Initialisable.PHASE_NAME);
        }
        if (Disposable.class.isAssignableFrom(HubModuleLifecycleAdapter.class)) {
            builder.setDestroyMethodName(Disposable.PHASE_NAME);
        }
        if ((element.getAttribute("objectStore-ref")!= null)&&(!StringUtils.isBlank(element.getAttribute("objectStore-ref")))) {
            builder.addPropertyValue("objectStore", new RuntimeBeanReference(element.getAttribute("objectStore-ref")));
        }
        if ((element.getAttribute("retryFrequency")!= null)&&(!StringUtils.isBlank(element.getAttribute("retryFrequency")))) {
            builder.addPropertyValue("retryFrequency", element.getAttribute("retryFrequency"));
        }
        if ((element.getAttribute("retryCount")!= null)&&(!StringUtils.isBlank(element.getAttribute("retryCount")))) {
            builder.addPropertyValue("retryCount", element.getAttribute("retryCount"));
        }
        if ((element.getAttribute("defaultLeaseSeconds")!= null)&&(!StringUtils.isBlank(element.getAttribute("defaultLeaseSeconds")))) {
            builder.addPropertyValue("defaultLeaseSeconds", element.getAttribute("defaultLeaseSeconds"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        return definition;
    }

}
