/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ognl.expression;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.lifecycle.Disposable;
import org.mule.config.i18n.CoreMessages;

public class OgnlExpressionEvaluator
implements ExpressionEvaluator,
Disposable {
    Map<String, Object> expressions = new ConcurrentHashMap<String, Object>(4);
    public static final String NAME = "ognl";
    protected final transient Log logger = LogFactory.getLog(OgnlExpressionEvaluator.class);

    public Object evaluate(String expression, MuleMessage message) {
        Object o = this.expressions.get(expression);
        if (o == null) {
            try {
                o = Ognl.parseExpression((String)expression);
                this.expressions.put(expression, o);
            }
            catch (OgnlException e) {
                throw new ExpressionRuntimeException(CoreMessages.expressionMalformed((String)expression, (String)NAME), (Throwable)e);
            }
        }
        try {
            return Ognl.getValue((Object)o, (Object)message.getPayload());
        }
        catch (OgnlException e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }

    public String getName() {
        return NAME;
    }

    public void dispose() {
        this.expressions.clear();
    }
}

