
package org.mule.module.netsuite.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.netsuite.processors.UpdateRecordMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class UpdateRecordDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public UpdateRecordDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(UpdateRecordMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if (element.hasAttribute("recordType")) {
            builder.addPropertyValue("recordType", element.getAttribute("recordType"));
        }
        if ((element.getAttribute("id")!= null)&&(!StringUtils.isBlank(element.getAttribute("id")))) {
            builder.addPropertyValue("id", element.getAttribute("id"));
        }
        if (element.hasAttribute("idType")) {
            builder.addPropertyValue("idType", element.getAttribute("idType"));
        }
        Element attributesListElement = null;
        attributesListElement = DomUtils.getChildElementByTagName(element, "attributes");
        List<Element> attributesMapChilds = null;
        if (attributesListElement!= null) {
            String attributesRef = attributesListElement.getAttribute("ref");
            if ((attributesRef!= null)&&(!StringUtils.isBlank(attributesRef))) {
                if ((!attributesRef.startsWith(patternInfo.getPrefix()))&&(!attributesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("attributes", new RuntimeBeanReference(attributesRef));
                } else {
                    builder.addPropertyValue("attributes", attributesRef);
                }
            } else {
                ManagedMap attributes = new ManagedMap();
                attributesMapChilds = DomUtils.getChildElementsByTagName(attributesListElement, "attribute");
                if (attributesMapChilds!= null) {
                    if (attributesMapChilds.size() == 0) {
                        attributesMapChilds = DomUtils.getChildElements(attributesListElement);
                    }
                    for (Element attributesChild: attributesMapChilds) {
                        String attributesValueRef = attributesChild.getAttribute("value-ref");
                        String attributesKeyRef = attributesChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((attributesValueRef!= null)&&(!StringUtils.isBlank(attributesValueRef))) {
                            if ((!attributesValueRef.startsWith(patternInfo.getPrefix()))&&(!attributesValueRef.endsWith(patternInfo.getSuffix()))) {
                                valueObject = new RuntimeBeanReference(attributesValueRef);
                            } else {
                                valueObject = attributesValueRef;
                            }
                        } else {
                            valueObject = attributesChild.getTextContent();
                        }
                        if ((attributesKeyRef!= null)&&(!StringUtils.isBlank(attributesKeyRef))) {
                            keyObject = new RuntimeBeanReference(attributesKeyRef);
                        } else {
                            keyObject = attributesChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = attributesChild.getTagName();
                        }
                        attributes.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("attributes", attributes);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
