
package org.mule.module.netsuite.config;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/netsuite</code>.
 * 
 */
public class NetSuiteCloudConnectorNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new NetSuiteCloudConnectorConfigDefinitionParser());
        registerBeanDefinitionParser("attach-record", new AttachRecordDefinitionParser());
        registerBeanDefinitionParser("delete-record", new DeleteRecordDefinitionParser());
        registerBeanDefinitionParser("detach-record", new DetachRecordDefinitionParser());
        registerBeanDefinitionParser("get-budget-exchange-rates", new GetBudgetExchangeRatesDefinitionParser());
        registerBeanDefinitionParser("get-consolidated-exchange-rates", new GetConsolidatedExchangeRatesDefinitionParser());
        registerBeanDefinitionParser("get-customization-ids", new GetCustomizationIdsDefinitionParser());
        registerBeanDefinitionParser("get-deleted-records", new GetDeletedRecordsDefinitionParser());
        registerBeanDefinitionParser("get-records", new GetRecordsDefinitionParser());
        registerBeanDefinitionParser("get-record", new GetRecordDefinitionParser());
        registerBeanDefinitionParser("get-item-availabilities", new GetItemAvailabilitiesDefinitionParser());
        registerBeanDefinitionParser("get-saved-search", new GetSavedSearchDefinitionParser());
        registerBeanDefinitionParser("get-server-time", new GetServerTimeDefinitionParser());
        registerBeanDefinitionParser("update-invitee-status", new UpdateInviteeStatusDefinitionParser());
        registerBeanDefinitionParser("add-record", new AddRecordDefinitionParser());
        registerBeanDefinitionParser("add-list", new AddListDefinitionParser());
        registerBeanDefinitionParser("update-list", new UpdateListDefinitionParser());
        registerBeanDefinitionParser("delete-list", new DeleteListDefinitionParser());
        registerBeanDefinitionParser("add-file", new AddFileDefinitionParser());
        registerBeanDefinitionParser("update-record", new UpdateRecordDefinitionParser());
        registerBeanDefinitionParser("check-async-status", new CheckAsyncStatusDefinitionParser());
        registerBeanDefinitionParser("find-records", new FindRecordsDefinitionParser());
        registerBeanDefinitionParser("find-first-record", new FindFirstRecordDefinitionParser());
        registerBeanDefinitionParser("saved-find-records", new SavedFindRecordsDefinitionParser());
        registerBeanDefinitionParser("async-find-records", new AsyncFindRecordsDefinitionParser());
        registerBeanDefinitionParser("get-async-find-result", new GetAsyncFindResultDefinitionParser());
        registerBeanDefinitionParser("get-async-find-first-result", new GetAsyncFindFirstResultDefinitionParser());
        registerBeanDefinitionParser("initialize", new InitializeDefinitionParser());
    }

}
