
package org.mule.module.netsuite.config;

import org.apache.commons.lang.StringUtils;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.module.netsuite.adapters.NetSuiteCloudConnectorLifecycleAdapter;
import org.mule.util.TemplateParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class NetSuiteCloudConnectorConfigDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public NetSuiteCloudConnectorConfigDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        String name = element.getAttribute("name");
        if ((name == null)||StringUtils.isBlank(name)) {
            element.setAttribute("name", AutoIdUtils.getUniqueName(element, "mule-bean"));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(NetSuiteCloudConnectorLifecycleAdapter.class.getName());
        if (Initialisable.class.isAssignableFrom(NetSuiteCloudConnectorLifecycleAdapter.class)) {
            builder.setInitMethodName(Initialisable.PHASE_NAME);
        }
        if (Disposable.class.isAssignableFrom(NetSuiteCloudConnectorLifecycleAdapter.class)) {
            builder.setDestroyMethodName(Disposable.PHASE_NAME);
        }
        if ((element.getAttribute("endpoint")!= null)&&(!StringUtils.isBlank(element.getAttribute("endpoint")))) {
            builder.addPropertyValue("endpoint", element.getAttribute("endpoint"));
        }
        if ((element.getAttribute("email")!= null)&&(!StringUtils.isBlank(element.getAttribute("email")))) {
            builder.addPropertyValue("email", element.getAttribute("email"));
        }
        if ((element.getAttribute("password")!= null)&&(!StringUtils.isBlank(element.getAttribute("password")))) {
            builder.addPropertyValue("password", element.getAttribute("password"));
        }
        if ((element.getAttribute("account")!= null)&&(!StringUtils.isBlank(element.getAttribute("account")))) {
            builder.addPropertyValue("account", element.getAttribute("account"));
        }
        if ((element.getAttribute("roleId")!= null)&&(!StringUtils.isBlank(element.getAttribute("roleId")))) {
            builder.addPropertyValue("roleId", element.getAttribute("roleId"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        return definition;
    }

}
