/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api.paging;

import org.mule.module.netsuite.api.CxfPortProvider;

import com.netsuite.webservices.platform.core_2010_2.SearchResult;
import com.netsuite.webservices.platform.messages_2010_2.AsyncSearchResult;
import com.netsuite.webservices.platform.messages_2010_2.GetAsyncResultRequest;

/**
 * @author flbulgarelli
 */
public final class AsyncRecordSearchIterable extends AbstractRecordSearchIterable
{

    private final String jobId;

    public AsyncRecordSearchIterable(CxfPortProvider portProvider, String jobId)
    {
        super(portProvider);
        this.jobId = jobId;
    }

    @Override
    protected SearchResult doSearch() throws Exception
    {
        return ((AsyncSearchResult) getPortProvider().getAuthenticatedPort().getAsyncResult(
            new GetAsyncResultRequest(jobId, 1)).getAsyncResult()).getSearchResult();
    }
}
