/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api.model.expression.filter;

import java.util.ArrayList;
import java.util.List;

import org.mule.module.netsuite.api.model.expression.Quotes;

import com.netsuite.webservices.platform.core_2010_2.RecordRef;

public class CollectionBuilder
{
    private List<Object> list = new ArrayList<Object>();

    public CollectionBuilder()
    {
    }

    public List<Object> build()
    {
        return list;
    }

    public void addEnumElement(String image)
    {
        list.add(image);
    }

    public void addInternalIdElement(String image)
    {
        list.add(new RecordRef(null, Quotes.removeQuotes(image), null));
    }

    public void addExternalIdElement(String image)
    {
        list.add(new RecordRef(null, null, Quotes.removeQuotes(image)));
    }
}
