/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api.model.expression.date;
import static org.mule.module.netsuite.api.model.expression.Quotes.*;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.datatype.XMLGregorianCalendar;

import org.mule.modules.utils.date.XmlGregorianCalendars;

import com.netsuite.webservices.platform.core_2010_2.SearchDateField;
import com.netsuite.webservices.platform.core_2010_2.types.SearchDate;
import com.netsuite.webservices.platform.core_2010_2.types.SearchDateFieldOperator;

public class DateExpressionBuilder
{
    private static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    private final SearchDateField searchDateField = new SearchDateField();

    public DateExpressionBuilder()
    {
    }

    public void setOperation(String opertion)
    {
        searchDateField.setOperator(SearchDateFieldOperator.fromValue(opertion));
    }

    public void setPredefinedSearchValue(String predefinedSearchValue)
    {
        searchDateField.setPredefinedSearchValue(SearchDate.fromValue(predefinedSearchValue));
    }

    // DATE

    public void setDateSearchValue(String date)
    {
        setDateSearchValueInternal(date, ISO_DATE_FORMAT);
    }

    public void setDateSearchValue(String date, String format)
    {
        setDateSearchValueInternal(removeQuotes(date), removeQuotes(format));
    }

    public void setDateSearchValueInternal(String date, String format)
    {
        try
        {
            searchDateField.setSearchValue(toXmlCalendar(new SimpleDateFormat(format).parse(date)));
        }
        catch (ParseException e)
        {
            throw soften(e);
        }
    }

    // DATE RANGE

    public void setRangeSearchValue(String minDate, String maxDate)
    {
        setRangeSearchValueInternal(minDate, maxDate, ISO_DATE_FORMAT);
    }

    public void setRangeSearchValue(String minDate, String maxDate, String format)
    {
        setRangeSearchValueInternal(removeQuotes(minDate), removeQuotes(maxDate), removeQuotes(format));
    }

    public void setRangeSearchValueInternal(String minDate, String maxDate, String format)
    {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try
        {
            searchDateField.setSearchValue(toXmlCalendar(dateFormat.parse(minDate)));
            searchDateField.setSearchValue2(toXmlCalendar(dateFormat.parse(maxDate)));
        }
        catch (ParseException e)
        {
            throw soften(e);
        }
    }

    public SearchDateField build()
    {
        return searchDateField;
    }

    private IllegalArgumentException soften(ParseException e)
    {
        return new IllegalArgumentException(e.getMessage());
    }

    public XMLGregorianCalendar toXmlCalendar(Date parse)
    {
        return XmlGregorianCalendars.from(parse);
    }

}
