/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api.model.expression;

import org.apache.commons.lang.StringUtils;

public final class Quotes
{

    private Quotes()
    {
    }

    public static String removeQuotesIfPresent(String string)
    {
        if (isQuoted(string))
        {
            return removeQuotes(string);
        }
        return string;
    }

    private static boolean isQuoted(String string)
    {
        char firstChar = string.charAt(0);
        return firstChar == string.charAt(string.length() - 1)
                && (firstChar == '"' || firstChar == '\'');
    }

    public static String removeQuotes(String quotedString)
    {
        return StringUtils
                .substring(quotedString, 1, quotedString.length() - 1);
    }
}
