/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api.model.entity;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.Validate;

import com.netsuite.webservices.platform.core_2010_2.InitializeRef;
import com.netsuite.webservices.platform.core_2010_2.RecordRef;
import com.netsuite.webservices.platform.core_2010_2.types.InitializeRefType;
import com.netsuite.webservices.platform.core_2010_2.types.RecordType;

public class RecordReference
{
    private final RecordId id;
    private final RecordType type;

    public RecordReference(@NotNull RecordId id, @NotNull RecordType type)
    {
        Validate.notNull(id);
        Validate.notNull(type);
        this.id = id;
        this.type = type;
    }

    @NotNull
    public RecordRef createRef()
    {
        RecordRef recordRef = id.createRef();
        recordRef.setType(type);
        return recordRef;
    }
    
    public InitializeRef createInitializeRef()
    {
        InitializeRef initializeRef = id.createInitializeRef();
        initializeRef.setType(InitializeRefType.fromValue(type.value()));
        return initializeRef;
    }
    
    
    public RecordType getType()
    {
        return type;
    }

    public RecordId getId()
    {
        return id;
    }


}
