/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.Validate;
import org.mule.module.netsuite.api.model.entity.RecordReference;

/**
 * Utility class for creating {@link RecordReferences} from connector arguments
 */
public final class RecordReferences
{
    private RecordReferences()
    {
    }

    public static RecordReference from(@NotNull RecordTypeEnum recordType,
                                       @NotNull String id,
                                       @NotNull RecordIdType idType)
    {
        Validate.notNull(recordType, "Must specify recordType");
        return new RecordReference(RecordIds.from(id, idType), recordType.toRecordType());
    }

    public static RecordReference nulSafeFrom(@NotNull RecordTypeEnum recordType,
                                              @NotNull String id,
                                              @NotNull RecordIdType idType)
    {
        return recordType != null ? from(recordType, id, idType)// 
                                 : fromNull(id, idType);
    }

    private static RecordReference fromNull(String id, RecordIdType idType)
    {
        Validate.isTrue(id == null, "Must specify recordType");
        return null;
    }

}
