/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite;

import com.netsuite.webservices.platform.core_2010_2.types.InitializeType;

public enum InitializeTypeEnum
{
    ASSEMBLY_UNBUILD(InitializeType.ASSEMBLY_UNBUILD),
    CASH_REFUND(InitializeType.CASH_REFUND),
    CASH_SALE(InitializeType.CASH_SALE),
    CREDIT_MEMO(InitializeType.CREDIT_MEMO),
    CUSTOMER_PAYMENT(InitializeType.CUSTOMER_PAYMENT),
    CUSTOMER_REFUND(InitializeType.CUSTOMER_REFUND),
    DEPOSIT_APPLICATION(InitializeType.DEPOSIT_APPLICATION),
    ESTIMATE(InitializeType.ESTIMATE),
    INVOICE(InitializeType.INVOICE),
    ITEM_FULFILLMENT(InitializeType.ITEM_FULFILLMENT),
    ITEM_RECEIPT(InitializeType.ITEM_RECEIPT),
    RETURN_AUTHORIZATION(InitializeType.RETURN_AUTHORIZATION),
    SALES_ORDER(InitializeType.SALES_ORDER),
    VENDOR_BILL(InitializeType.VENDOR_BILL),
    VENDOR_PAYMENT(InitializeType.VENDOR_PAYMENT);
    
    private final InitializeType initializeType;

    private InitializeTypeEnum(InitializeType initializeType)
    {
        this.initializeType = initializeType;
    }

    public InitializeType toInitializeType()
    {
        return initializeType;
    }

}


