
package org.mule.module.netsuite.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.netsuite.processors.UpdateListMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class UpdateListDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public UpdateListDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(UpdateListMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if (element.hasAttribute("recordType")) {
            builder.addPropertyValue("recordType", element.getAttribute("recordType"));
        }
        Element recordsListElement = null;
        recordsListElement = DomUtils.getChildElementByTagName(element, "records");
        List<Element> recordsListChilds = null;
        if (recordsListElement!= null) {
            String recordsRef = recordsListElement.getAttribute("ref");
            if ((recordsRef!= null)&&(!StringUtils.isBlank(recordsRef))) {
                if ((!recordsRef.startsWith(patternInfo.getPrefix()))&&(!recordsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("records", new RuntimeBeanReference(recordsRef));
                } else {
                    builder.addPropertyValue("records", recordsRef);
                }
            } else {
                ManagedList records = new ManagedList();
                recordsListChilds = DomUtils.getChildElementsByTagName(recordsListElement, "record");
                if (recordsListChilds!= null) {
                    for (Element recordsChild: recordsListChilds) {
                        String valueRef = recordsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            if ((!valueRef.startsWith(patternInfo.getPrefix()))&&(!valueRef.endsWith(patternInfo.getSuffix()))) {
                                records.add(new RuntimeBeanReference(valueRef));
                            } else {
                                records.add(valueRef);
                            }
                        } else {
                            List<Element> innerrecordMapChilds = null;
                            if (recordsChild!= null) {
                                String innerrecordRef = recordsChild.getAttribute("ref");
                                if ((innerrecordRef!= null)&&(!StringUtils.isBlank(innerrecordRef))) {
                                    if ((!innerrecordRef.startsWith(patternInfo.getPrefix()))&&(!innerrecordRef.endsWith(patternInfo.getSuffix()))) {
                                        builder.addPropertyValue("inner-record", new RuntimeBeanReference(innerrecordRef));
                                    } else {
                                        builder.addPropertyValue("inner-record", innerrecordRef);
                                    }
                                } else {
                                    ManagedMap innerrecord = new ManagedMap();
                                    innerrecordMapChilds = DomUtils.getChildElementsByTagName(recordsChild, "inner-record");
                                    if (innerrecordMapChilds!= null) {
                                        if (innerrecordMapChilds.size() == 0) {
                                            innerrecordMapChilds = DomUtils.getChildElements(recordsChild);
                                        }
                                        for (Element innerrecordChild: innerrecordMapChilds) {
                                            String innerrecordValueRef = innerrecordChild.getAttribute("value-ref");
                                            String innerrecordKeyRef = innerrecordChild.getAttribute("key-ref");
                                            Object valueObject = null;
                                            Object keyObject = null;
                                            if ((innerrecordValueRef!= null)&&(!StringUtils.isBlank(innerrecordValueRef))) {
                                                if ((!innerrecordValueRef.startsWith(patternInfo.getPrefix()))&&(!innerrecordValueRef.endsWith(patternInfo.getSuffix()))) {
                                                    valueObject = new RuntimeBeanReference(innerrecordValueRef);
                                                } else {
                                                    valueObject = innerrecordValueRef;
                                                }
                                            } else {
                                                valueObject = innerrecordChild.getTextContent();
                                            }
                                            if ((innerrecordKeyRef!= null)&&(!StringUtils.isBlank(innerrecordKeyRef))) {
                                                keyObject = new RuntimeBeanReference(innerrecordKeyRef);
                                            } else {
                                                keyObject = innerrecordChild.getAttribute("key");
                                            }
                                            if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                                                keyObject = innerrecordChild.getTagName();
                                            }
                                            innerrecord.put(keyObject, valueObject);
                                        }
                                    }
                                    records.add(innerrecord);
                                }
                            }
                        }
                    }
                }
                builder.addPropertyValue("records", records);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
