/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api.paging;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.UnhandledException;
import org.mule.module.netsuite.api.CxfPortProvider;

import com.netsuite.webservices.platform.core_2010_2.SearchRecord;
import com.netsuite.webservices.platform.core_2010_2.SearchResult;
import com.netsuite.webservices.platform.core_2010_2.types.SearchRecordType;
import com.netsuite.webservices.platform.messages_2010_2.SearchRequest;

public final class SavedRecordSearchIterable extends AbstractRecordSearchIterable
{

    private final SearchRecordType recordType;
    private final String savedSearchId;

    public SavedRecordSearchIterable(CxfPortProvider portProvider,
                                     SearchRecordType recordType,
                                     String searchId)
    {
        super(portProvider);
        this.recordType = recordType;
        this.savedSearchId = searchId;
    }

    @Override
    protected SearchResult doSearch() throws Exception
    {
        return getPortProvider().getAuthenticatedPort()
            .search(new SearchRequest(createAdvancedSearch()))
            .getSearchResult();
    }

    private SearchRecord createAdvancedSearch()
    {
        SearchRecord search = recordType.newAdvancedSearchInstance();
        try
        {
            PropertyUtils.setProperty(search, "savedSearchId", savedSearchId);
        }
        catch (Exception e)
        {
            throw new UnhandledException(e);
        }
        return search;
    }
}
