/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api.paging;

import org.mule.module.netsuite.api.CxfPortProvider;
import org.mule.module.netsuite.api.model.expression.filter.parser.FilterExpressionParser;

import com.netsuite.webservices.platform.core_2010_2.SearchResult;
import com.netsuite.webservices.platform.core_2010_2.types.SearchRecordType;
import com.netsuite.webservices.platform.messages_2010_2.SearchRequest;

public final class RecordSearchIterable extends AbstractRecordSearchIterable
{

    private final SearchRecordType recordType;
    private final String expression;

    public RecordSearchIterable(CxfPortProvider portProvider, SearchRecordType recordType, String expression)
    {
        super(portProvider);
        this.recordType = recordType;
        this.expression = expression;
    }

    @Override
    protected SearchResult doSearch() throws Exception
    {
        return getPortProvider().getAuthenticatedPort().search(
            new SearchRequest(FilterExpressionParser.parse(recordType, expression))).getSearchResult();
    }
}
