/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api.paging;

import java.util.Iterator;

import org.mule.module.netsuite.api.CxfPortProvider;
import org.mule.module.netsuite.api.NetSuiteGenericException;
import org.mule.module.netsuite.api.ResultStatuses;
import org.mule.modules.utils.pagination.PaginatedIterable;

import com.netsuite.webservices.platform.core_2010_2.Record;
import com.netsuite.webservices.platform.core_2010_2.SearchResult;
import com.netsuite.webservices.platform_2010_2.InvalidSessionFault;
import com.netsuite.webservices.platform.messages_2010_2.SearchMoreWithIdRequest;

/**
 * @author flbulgarelli
 */
public abstract class AbstractRecordSearchIterable extends PaginatedIterable<Record, SearchResult>
{
    private final CxfPortProvider portProvider;

    public AbstractRecordSearchIterable(CxfPortProvider portProvider)
    {
        this.portProvider = portProvider;
    }

    public CxfPortProvider getPortProvider()
    {
        return portProvider;
    }

    @Override
    protected SearchResult firstPage()
    {
        try
        {
            return ResultStatuses.checkStatus(doSearch());
        }
        catch (InvalidSessionFault isf)
        {
            try
            {
                getPortProvider().login();
                return firstPage();
            }
            catch (Exception e)
            {
                throw NetSuiteGenericException.soften(e);
            }
        }
        catch (Exception e)
        {
            throw NetSuiteGenericException.soften(e);
        }
    }

    protected abstract SearchResult doSearch() throws Exception;

    @Override
    protected boolean hasNextPage(SearchResult result)
    {
        ResultStatuses.checkStatus(result);
        return result.getPageSize() != null && result.getPageIndex() != null
               && result.getTotalRecords() > result.getPageSize() * result.getPageIndex();
    }

    @Override
    protected SearchResult nextPage(SearchResult currentPage)
    {
        try
        {
            return getPortProvider().getAuthenticatedPort()
                .searchMoreWithId(
                    new SearchMoreWithIdRequest(currentPage.getSearchId(), currentPage.getPageIndex() + 1))
                .getSearchResult();
        }
        catch (InvalidSessionFault isf)
        {
            try
            {
                getPortProvider().login();
                return nextPage(currentPage);
            }
            catch (Exception e)
            {
                throw NetSuiteGenericException.soften(e);
            }
        }
        catch (Exception e)
        {
            throw NetSuiteGenericException.soften(e);
        }
    }

    @Override
    protected Iterator<Record> pageIterator(SearchResult page)
    {
        return page.getRecordList().getRecord().iterator();
    }
}
