/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api.model.expression.date;

import org.mule.module.netsuite.api.model.expression.date.parser.DateExpressionParser;

import com.netsuite.webservices.platform.core_2010_2.SearchDateField;

/**
 * An implementation of {@link DateExpression} that constructs
 * {@link SearchDateField}s from a String using a {@link DateExpressionParser}
 */
public final class StringDateExpression implements DateExpression
{

    private final String expression;

    public StringDateExpression(String expression)
    {
        this.expression = expression;
    }

    public SearchDateField createSearchDateField()
    {
        return DateExpressionParser.parse(expression);
    }
}
