/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api.model.entity;

import java.util.Map;

import org.apache.commons.lang.Validate;

import com.netsuite.webservices.platform.core_2010_2.InitializeRef;
import com.netsuite.webservices.platform.core_2010_2.RecordRef;

public interface RecordId
{
    RecordRef createRef();

    InitializeRef createInitializeRef();

    Map<String, Object> populate(Map<String, Object> recordAttributes);

    abstract class AbstractId implements RecordId
    {
        private final String id;

        public AbstractId(String id)
        {
            Validate.notNull(id);
            this.id = id;
        }

        public RecordRef createRef()
        {
            RecordRef recordRef = new RecordRef();
            populate(recordRef);
            return recordRef;
        }
        
        public InitializeRef createInitializeRef()
        {
            InitializeRef ref = new InitializeRef();
            populate(ref);
            return ref;
        }

        abstract void populate(NetsuiteReference recordRef);

        public String getId()
        {
            return id;
        }
    }

    class ExternalId extends AbstractId
    {

        public ExternalId(String id)
        {
            super(id);
        }

        public void populate(NetsuiteReference recordRef)
        {
            recordRef.setExternalId(getId());
        }

        public Map<String, Object> populate(Map<String, Object> recordAttributes)
        {
            recordAttributes.put("externalId", getId());
            return recordAttributes;
        }
    }

    class InternalId extends AbstractId
    {

        public InternalId(String id)
        {
            super(id);
        }

        public void populate(NetsuiteReference recordRef)
        {
            recordRef.setInternalId(getId());
        }

        public Map<String, Object> populate(Map<String, Object> recordAttributes)
        {
            recordAttributes.put("internalId", getId());
            return recordAttributes;
        }
    }

}
