/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api.annotation;

import static org.apache.commons.beanutils.MethodUtils.*;

import java.util.List;

import org.mule.module.netsuite.api.ResultStatuses;

public enum ReturnType
{

    VOID
    {
        @Override
        public Object adaptImpl(Object result, String recordName) throws Throwable
        {
            return null;
        }
    },
    RECORD
    {
        @Override
        public Object adaptImpl(Object result, String recordName) throws Throwable
        {
            return invokeExactMethod(result, "get" + recordName, EMPTY_ARRAY);
        }
    },
    LIST
    {
        @SuppressWarnings("unchecked")
        @Override
        public List<Object> adaptImpl(Object result, String recordName) throws Throwable
        {
            return (List<Object>) invokeExactMethod(invokeExactMethod(result, "get" + recordName + "List",
                EMPTY_ARRAY), "get" + recordName, EMPTY_ARRAY);
        }

    };

    private static final Object[] EMPTY_ARRAY = new Object[0];

    protected abstract Object adaptImpl(Object returnValue, String recordName) throws Throwable;

    public Object adapt(Object returnValue, String responseName, String resultName) throws Throwable
    {
        Object result = invokeExactMethod(returnValue, "get" + responseName, EMPTY_ARRAY);
        ResultStatuses.checkStatus(result);
        return adaptImpl(result, resultName);
    }

}
