/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.mule.module.netsuite.api.SoapNetSuiteClient;

/**
 * Metadata of a {@link SoapNetSuiteClient} Method
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface NetSuiteOperation
{
    /**
     * @return the name of the attribute of the operation response that represent the
     *         response wrapper object, in CamelCase
     */
    String responseName() default "WriteResponse";

    /**
     * @return the name of the attribute of the response wrapper object that
     *         represents the actual meaningful result of the operation, in CamelCase
     */
    String resultName() default "";

    ReturnType resultType() default ReturnType.VOID;

    /**
     * @return if return types of operation should be adapted. responseName,
     *         resultName and resultType have only sense if adapt is set to true
     */
    boolean adapt() default true;

}
