/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.netsuite.webservices.platform.core_2010_2.Status;

public final class ResultStatuses
{
    private ResultStatuses()
    {
    }

    public static <T> T checkStatus(T result)
    {
        Status status;
        try
        {
            status = (Status) PropertyUtils.getProperty(result, "status");
        }
        catch (Exception e)
        {
            throw new IllegalArgumentException("Result " + result.getClass() + " has no status property");
        }
        if (status.isIsSuccess())
        {
            return result;
        }
        throw new NetSuiteGenericException("Request failed. Details: " + getStatusDetails(status));
    }

    private static String getStatusDetails(Status status)
    {
        if (status.getStatusDetail().isEmpty())
        {
            return "<no details>";
        }
        return ToStringBuilder.reflectionToString(status.getStatusDetail().get(0));
    }
}
