/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite.api;

import javax.validation.constraints.NotNull;
import javax.xml.ws.BindingProvider;

import org.apache.commons.lang.Validate;

import com.netsuite.webservices.platform.core_2010_2.Passport;
import com.netsuite.webservices.platform.core_2010_2.RecordRef;
import com.netsuite.webservices.platform.messages_2010_2.LoginRequest;
import com.netsuite.webservices.platform_2010_2.NetSuitePortType;
import com.netsuite.webservices.platform_2010_2.NetSuiteService;
import com.zauberlabs.commons.ws.connection.ConnectionBuilder;

public class DefaultCxfPortProvider implements CxfPortProvider
{
    private final String address;
    private final String email;
    private final String password;
    private final String account;
    private final String roleId;
    private NetSuitePortType port;

    /**
     * Creates the port provider
     *
     * @param address
     * @param email
     * @param password
     * @param account
     * @param roleId
     */
    public DefaultCxfPortProvider(@NotNull String address,
                                   @NotNull String email,
                                   @NotNull String password,
                                   @NotNull String account,
                                   @NotNull String roleId)
    {
        Validate.notNull(address);
        Validate.notNull(email);
        Validate.notNull(password);
        Validate.notNull(account);
        Validate.notNull(roleId);
        this.address = address;
        this.email = email;
        this.password = password;
        this.account = account;
        this.roleId = roleId;
    }

    private NetSuitePortType getPort() throws Exception
    {
        if (port == null) 
        {
            port = ConnectionBuilder.fromPortType(NetSuitePortType.class)
                            .withServiceType(NetSuiteService.class)
                            .withClasspathWsdl("netsuite.wsdl")
                            .withEndpoint(address)
                            .build();
            
            ((BindingProvider) port).getRequestContext().put(BindingProvider.SESSION_MAINTAIN_PROPERTY, true);
            port.login(new LoginRequest(new Passport(email, password, account, new RecordRef(null, roleId, null))));
        }
        return port;
    }

    public NetSuitePortType getAuthenticatedPort() throws Exception
    {
        return getPort();
    }
    
    public void login() throws Exception
    {
        getPort().login(new LoginRequest(new Passport(email, password, account, new RecordRef(null, roleId, null))));
    }

}
