/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite;

import com.netsuite.webservices.platform.core_2010_2.types.RecordType;

/**
 * RecordType
 * 
 * @author flbulgarelli
 */
public enum RecordTypeEnum
{
    
    ACCOUNT(RecordType.ACCOUNT),
    ACCOUNTING_PERIOD(RecordType.ACCOUNTING_PERIOD),
    ASSEMBLY_BUILD(RecordType.ASSEMBLY_BUILD),
    ASSEMBLY_UNBUILD(RecordType.ASSEMBLY_UNBUILD),
    ASSEMBLY_ITEM(RecordType.ASSEMBLY_ITEM),
    BIN(RecordType.BIN),
    BUDGET(RecordType.BUDGET),
    BUDGET_CATEGORY(RecordType.BUDGET_CATEGORY),
    CALENDAR_EVENT(RecordType.CALENDAR_EVENT),
    CAMPAIGN(RecordType.CAMPAIGN),
    CAMPAIGN_AUDIENCE(RecordType.CAMPAIGN_AUDIENCE),
    CAMPAIGN_CATEGORY(RecordType.CAMPAIGN_CATEGORY),
    CAMPAIGN_CHANNEL(RecordType.CAMPAIGN_CHANNEL),
    CAMPAIGN_FAMILY(RecordType.CAMPAIGN_FAMILY),
    CAMPAIGN_OFFER(RecordType.CAMPAIGN_OFFER),
    CAMPAIGN_RESPONSE(RecordType.CAMPAIGN_RESPONSE),
    CAMPAIGN_SEARCH_ENGINE(RecordType.CAMPAIGN_SEARCH_ENGINE),
    CAMPAIGN_SUBSCRIPTION(RecordType.CAMPAIGN_SUBSCRIPTION),
    CAMPAIGN_VERTICAL(RecordType.CAMPAIGN_VERTICAL),
    CASH_REFUND(RecordType.CASH_REFUND),
    CASH_SALE(RecordType.CASH_SALE),
    CHECK(RecordType.CHECK),
    CLASSIFICATION(RecordType.CLASSIFICATION),
    CONTACT(RecordType.CONTACT),
    CONTACT_CATEGORY(RecordType.CONTACT_CATEGORY),
    CONTACT_ROLE(RecordType.CONTACT_ROLE),
    CREDIT_MEMO(RecordType.CREDIT_MEMO),
    CRM_CUSTOM_FIELD(RecordType.CRM_CUSTOM_FIELD),
    CURRENCY(RecordType.CURRENCY),
    CUSTOM_LIST(RecordType.CUSTOM_LIST),
    CUSTOM_RECORD(RecordType.CUSTOM_RECORD),
    CUSTOM_RECORD_CUSTOM_FIELD(RecordType.CUSTOM_RECORD_CUSTOM_FIELD),
    CUSTOM_RECORD_TYPE(RecordType.CUSTOM_RECORD_TYPE),
    CUSTOMER(RecordType.CUSTOMER),
    CUSTOMER_CATEGORY(RecordType.CUSTOMER_CATEGORY),
    CUSTOMER_DEPOSIT(RecordType.CUSTOMER_DEPOSIT),
    CUSTOMER_PAYMENT(RecordType.CUSTOMER_PAYMENT),
    CUSTOMER_REFUND(RecordType.CUSTOMER_REFUND),
    CUSTOMER_STATUS(RecordType.CUSTOMER_STATUS),
    DEPOSIT_APPLICATION(RecordType.DEPOSIT_APPLICATION),
    DEPARTMENT(RecordType.DEPARTMENT),
    DESCRIPTION_ITEM(RecordType.DESCRIPTION_ITEM),
    DISCOUNT_ITEM(RecordType.DISCOUNT_ITEM),
    DOWNLOAD_ITEM(RecordType.DOWNLOAD_ITEM),
    EMPLOYEE(RecordType.EMPLOYEE),
    ENTITY_CUSTOM_FIELD(RecordType.ENTITY_CUSTOM_FIELD),
    ENTITY_GROUP(RecordType.ENTITY_GROUP),
    ESTIMATE(RecordType.ESTIMATE),
    EXPENSE_CATEGORY(RecordType.EXPENSE_CATEGORY),
    EXPENSE_REPORT(RecordType.EXPENSE_REPORT),
    FILE(RecordType.FILE),
    FOLDER(RecordType.FOLDER),
    GIFT_CERTIFICATE(RecordType.GIFT_CERTIFICATE),
    GIFT_CERTIFICATE_ITEM(RecordType.GIFT_CERTIFICATE_ITEM),
    INTER_COMPANY_JOURNAL_ENTRY(RecordType.INTER_COMPANY_JOURNAL_ENTRY),
    INTER_COMPANY_TRANSFER_ORDER(RecordType.INTER_COMPANY_TRANSFER_ORDER),
    INVENTORY_ADJUSTMENT(RecordType.INVENTORY_ADJUSTMENT),
    INVENTORY_ITEM(RecordType.INVENTORY_ITEM),
    INVOICE(RecordType.INVOICE),
    ITEM_CUSTOM_FIELD(RecordType.ITEM_CUSTOM_FIELD),
    ITEM_FULFILLMENT(RecordType.ITEM_FULFILLMENT),
    ITEM_NUMBER_CUSTOM_FIELD(RecordType.ITEM_NUMBER_CUSTOM_FIELD),
    ITEM_OPTION_CUSTOM_FIELD(RecordType.ITEM_OPTION_CUSTOM_FIELD),
    ISSUE(RecordType.ISSUE),
    JOB(RecordType.JOB),
    JOB_STATUS(RecordType.JOB_STATUS),
    JOB_TYPE(RecordType.JOB_TYPE),
    ITEM_RECEIPT(RecordType.ITEM_RECEIPT),
    JOURNAL_ENTRY(RecordType.JOURNAL_ENTRY),
    KIT_ITEM(RecordType.KIT_ITEM),
    LEAD_SOURCE(RecordType.LEAD_SOURCE),
    LOCATION(RecordType.LOCATION),
    LOT_NUMBERED_INVENTORY_ITEM(RecordType.LOT_NUMBERED_INVENTORY_ITEM),
    LOT_NUMBERED_ASSEMBLY_ITEM(RecordType.LOT_NUMBERED_ASSEMBLY_ITEM),
    MARKUP_ITEM(RecordType.MARKUP_ITEM),
    MESSAGE(RecordType.MESSAGE),
    NON_INVENTORY_PURCHASE_ITEM(RecordType.NON_INVENTORY_PURCHASE_ITEM),
    NON_INVENTORY_RESALE_ITEM(RecordType.NON_INVENTORY_RESALE_ITEM),
    NON_INVENTORY_SALE_ITEM(RecordType.NON_INVENTORY_SALE_ITEM),
    NOTE(RecordType.NOTE),
    NOTE_TYPE(RecordType.NOTE_TYPE),
    OPPORTUNITY(RecordType.OPPORTUNITY),
    OTHER_CHARGE_PURCHASE_ITEM(RecordType.OTHER_CHARGE_PURCHASE_ITEM),
    OTHER_CHARGE_RESALE_ITEM(RecordType.OTHER_CHARGE_RESALE_ITEM),
    OTHER_CHARGE_SALE_ITEM(RecordType.OTHER_CHARGE_SALE_ITEM),
    OTHER_CUSTOM_FIELD(RecordType.OTHER_CUSTOM_FIELD),
    PARTNER(RecordType.PARTNER),
    PARTNER_CATEGORY(RecordType.PARTNER_CATEGORY),
    PAYMENT_ITEM(RecordType.PAYMENT_ITEM),
    PAYMENT_METHOD(RecordType.PAYMENT_METHOD),
    PHONE_CALL(RecordType.PHONE_CALL),
    PRICE_LEVEL(RecordType.PRICE_LEVEL),
    PROJECT_TASK(RecordType.PROJECT_TASK),
    PROMOTION_CODE(RecordType.PROMOTION_CODE),
    PURCHASE_ORDER(RecordType.PURCHASE_ORDER),
    RETURN_AUTHORIZATION(RecordType.RETURN_AUTHORIZATION),
    SALES_ORDER(RecordType.SALES_ORDER),
    SALES_ROLE(RecordType.SALES_ROLE),
    SALES_TAX_ITEM(RecordType.SALES_TAX_ITEM),
    SERIALIZED_INVENTORY_ITEM(RecordType.SERIALIZED_INVENTORY_ITEM),
    SERIALIZED_ASSEMBLY_ITEM(RecordType.SERIALIZED_ASSEMBLY_ITEM),
    SERVICE_PURCHASE_ITEM(RecordType.SERVICE_PURCHASE_ITEM),
    SERVICE_RESALE_ITEM(RecordType.SERVICE_RESALE_ITEM),
    SERVICE_SALE_ITEM(RecordType.SERVICE_SALE_ITEM),
    SOLUTION(RecordType.SOLUTION),
    SITE_CATEGORY(RecordType.SITE_CATEGORY),
    STATE(RecordType.STATE),
    SUBSIDIARY(RecordType.SUBSIDIARY),
    SUBTOTAL_ITEM(RecordType.SUBTOTAL_ITEM),
    SUPPORT_CASE(RecordType.SUPPORT_CASE),
    SUPPORT_CASE_ISSUE(RecordType.SUPPORT_CASE_ISSUE),
    SUPPORT_CASE_ORIGIN(RecordType.SUPPORT_CASE_ORIGIN),
    SUPPORT_CASE_PRIORITY(RecordType.SUPPORT_CASE_PRIORITY),
    SUPPORT_CASE_STATUS(RecordType.SUPPORT_CASE_STATUS),
    SUPPORT_CASE_TYPE(RecordType.SUPPORT_CASE_TYPE),
    TASK(RecordType.TASK),
    TAX_GROUP(RecordType.TAX_GROUP),
    TAX_TYPE(RecordType.TAX_TYPE),
    TERM(RecordType.TERM),
    TIME_BILL(RecordType.TIME_BILL),
    TOPIC(RecordType.TOPIC),
    TRANSFER_ORDER(RecordType.TRANSFER_ORDER),
    TRANSACTION_BODY_CUSTOM_FIELD(RecordType.TRANSACTION_BODY_CUSTOM_FIELD),
    TRANSACTION_COLUMN_CUSTOM_FIELD(RecordType.TRANSACTION_COLUMN_CUSTOM_FIELD),
    UNITS_TYPE(RecordType.UNITS_TYPE),
    VENDOR(RecordType.VENDOR),
    VENDOR_CATEGORY(RecordType.VENDOR_CATEGORY),
    VENDOR_BILL(RecordType.VENDOR_BILL),
    VENDOR_PAYMENT(RecordType.VENDOR_PAYMENT),
    WIN_LOSS_REASON(RecordType.WIN_LOSS_REASON);
    
    private RecordType recordType;
    
    private RecordTypeEnum(RecordType recordType)
    {
        this.recordType = recordType;
    }

    public RecordType toRecordType()
    {
        return recordType;
    }

    public String value()
    {
        return recordType.value();
    }
}
