/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.netsuite;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.Validate;
import org.mule.module.netsuite.api.model.entity.RecordId;

public final class RecordIds
{
    private RecordIds()
    {
    }

    public static RecordId from(@NotNull String id, @NotNull RecordIdType recordIdType)
    {
        Validate.notEmpty(id);
        Validate.notNull(recordIdType);
        return recordIdType.newId(id);
    }

    public static RecordId nullSafeFrom(String id, RecordIdType recordIdType)
    {
        return id != null ? from(id, recordIdType) : null;
    }
}
