/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.neo4j.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.annotate.JsonValue;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.mule.modules.neo4j.model.RelationshipQuery;
import org.mule.modules.neo4j.model.TraversalScript;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(value={"order", "relationships", "uniqueness", "return_filter", "prune_evaluator", "max_depth"})
public class TraversalQuery {
    @JsonProperty(value="order")
    private Order order;
    @JsonProperty(value="relationships")
    private List<RelationshipQuery> relationships = new ArrayList<RelationshipQuery>();
    @JsonProperty(value="uniqueness")
    private Uniqueness uniqueness;
    @JsonProperty(value="return_filter")
    private TraversalScript returnFilter;
    @JsonProperty(value="prune_evaluator")
    private TraversalScript pruneEvaluator;
    @JsonProperty(value="max_depth")
    private Integer maxDepth;

    @JsonProperty(value="order")
    public Order getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    public void setOrder(Order order) {
        this.order = order;
    }

    public TraversalQuery withOrder(Order order) {
        this.order = order;
        return this;
    }

    @JsonProperty(value="relationships")
    public List<RelationshipQuery> getRelationships() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    public void setRelationships(List<RelationshipQuery> relationships) {
        this.relationships = relationships;
    }

    public TraversalQuery withRelationships(List<RelationshipQuery> relationships) {
        this.relationships = relationships;
        return this;
    }

    @JsonProperty(value="uniqueness")
    public Uniqueness getUniqueness() {
        return this.uniqueness;
    }

    @JsonProperty(value="uniqueness")
    public void setUniqueness(Uniqueness uniqueness) {
        this.uniqueness = uniqueness;
    }

    public TraversalQuery withUniqueness(Uniqueness uniqueness) {
        this.uniqueness = uniqueness;
        return this;
    }

    @JsonProperty(value="return_filter")
    public TraversalScript getReturnFilter() {
        return this.returnFilter;
    }

    @JsonProperty(value="return_filter")
    public void setReturnFilter(TraversalScript returnFilter) {
        this.returnFilter = returnFilter;
    }

    public TraversalQuery withReturnFilter(TraversalScript returnFilter) {
        this.returnFilter = returnFilter;
        return this;
    }

    @JsonProperty(value="prune_evaluator")
    public TraversalScript getPruneEvaluator() {
        return this.pruneEvaluator;
    }

    @JsonProperty(value="prune_evaluator")
    public void setPruneEvaluator(TraversalScript pruneEvaluator) {
        this.pruneEvaluator = pruneEvaluator;
    }

    public TraversalQuery withPruneEvaluator(TraversalScript pruneEvaluator) {
        this.pruneEvaluator = pruneEvaluator;
        return this;
    }

    @JsonProperty(value="max_depth")
    public Integer getMaxDepth() {
        return this.maxDepth;
    }

    @JsonProperty(value="max_depth")
    public void setMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }

    public TraversalQuery withMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    public static enum Uniqueness {
        NODE_GLOBAL("node_global"),
        NONE("none"),
        RELATIONSHIP_GLOBAL("relationship_global"),
        NODE_PATH("node_path"),
        RELATIONSHIP_PATH("relationship_path");

        private final String value;
        private static Map<String, Uniqueness> constants;

        private Uniqueness(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Uniqueness fromValue(String value) {
            Uniqueness constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, Uniqueness>();
            for (Uniqueness c : Uniqueness.values()) {
                constants.put(c.value, c);
            }
        }
    }

    public static enum Order {
        BREADTH_FIRST("breadth_first"),
        DEPTH_FIRST("depth_first");

        private final String value;
        private static Map<String, Order> constants;

        private Order(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Order fromValue(String value) {
            Order constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, Order>();
            for (Order c : Order.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

