/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.neo4j.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.annotate.JsonValue;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.mule.modules.neo4j.model.RelationshipQuery;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(value={"algorithm", "to", "relationships", "max_depth", "cost_property", "default_cost"})
public class PathQuery {
    @JsonProperty(value="algorithm")
    private Algorithm algorithm;
    @JsonProperty(value="to")
    private String to;
    @JsonProperty(value="relationships")
    private RelationshipQuery relationships;
    @JsonProperty(value="max_depth")
    private Integer maxDepth;
    @JsonProperty(value="cost_property")
    private String costProperty;
    @JsonProperty(value="default_cost")
    private Double defaultCost;

    @JsonProperty(value="algorithm")
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public PathQuery withAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonProperty(value="to")
    public void setTo(String to) {
        this.to = to;
    }

    public PathQuery withTo(String to) {
        this.to = to;
        return this;
    }

    @JsonProperty(value="relationships")
    public RelationshipQuery getRelationships() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    public void setRelationships(RelationshipQuery relationships) {
        this.relationships = relationships;
    }

    public PathQuery withRelationships(RelationshipQuery relationships) {
        this.relationships = relationships;
        return this;
    }

    @JsonProperty(value="max_depth")
    public Integer getMaxDepth() {
        return this.maxDepth;
    }

    @JsonProperty(value="max_depth")
    public void setMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }

    public PathQuery withMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    @JsonProperty(value="cost_property")
    public String getCostProperty() {
        return this.costProperty;
    }

    @JsonProperty(value="cost_property")
    public void setCostProperty(String costProperty) {
        this.costProperty = costProperty;
    }

    public PathQuery withCostProperty(String costProperty) {
        this.costProperty = costProperty;
        return this;
    }

    @JsonProperty(value="default_cost")
    public Double getDefaultCost() {
        return this.defaultCost;
    }

    @JsonProperty(value="default_cost")
    public void setDefaultCost(Double defaultCost) {
        this.defaultCost = defaultCost;
    }

    public PathQuery withDefaultCost(Double defaultCost) {
        this.defaultCost = defaultCost;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    public static enum Algorithm {
        SHORTEST_PATH("shortestPath"),
        ALL_SIMPLE_PATHS("allSimplePaths"),
        ALL_PATHS("allPaths"),
        DIJKSTRA("dijkstra");

        private final String value;
        private static Map<String, Algorithm> constants;

        private Algorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Algorithm fromValue(String value) {
            Algorithm constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, Algorithm>();
            for (Algorithm c : Algorithm.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

