/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.neo4j.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transport.Connector;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.modules.neo4j.adapters.Neo4jConnectorConnectionIdentifierAdapter;
import org.mule.modules.neo4j.basic.Capabilities;
import org.mule.modules.neo4j.basic.Capability;
import org.mule.modules.neo4j.basic.MetadataAware;
import org.mule.modules.neo4j.connection.ConnectionManager;
import org.mule.modules.neo4j.connectivity.ManagedConnectionProcessTemplate;
import org.mule.modules.neo4j.connectivity.Neo4jConnectorConnectionFactory;
import org.mule.modules.neo4j.connectivity.Neo4jConnectorConnectionKey;
import org.mule.modules.neo4j.process.ProcessAdapter;
import org.mule.modules.neo4j.process.ProcessTemplate;

public class Neo4jConnectorConnectionManager
implements MuleContextAware,
Initialisable,
Testable,
Capabilities,
MetadataAware,
ConnectionManager<Neo4jConnectorConnectionKey, Neo4jConnectorConnectionIdentifierAdapter>,
ProcessAdapter<Neo4jConnectorConnectionIdentifierAdapter> {
    private String baseUri;
    private String user;
    private String password;
    private boolean streaming;
    private Connector connector;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Neo4j";
    private static final String MODULE_VERSION = "1.0";
    private static final String DEVKIT_VERSION = "3.4.0";
    private static final String DEVKIT_BUILD = "3.4.0.1555.8df15c1";

    public void setUser(String value) {
        this.user = value;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setStreaming(boolean value) {
        this.streaming = value;
    }

    public boolean getStreaming() {
        return this.streaming;
    }

    public void setConnector(Connector value) {
        this.connector = value;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    @Override
    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setBaseUri(String value) {
        this.baseUri = value;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.connectionPoolingProfile != null) {
            config.maxIdle = this.connectionPoolingProfile.getMaxIdle();
            config.maxActive = this.connectionPoolingProfile.getMaxActive();
            config.maxWait = this.connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.connectionPoolingProfile.getExhaustedAction();
            config.timeBetweenEvictionRunsMillis = this.connectionPoolingProfile.getEvictionCheckIntervalMillis();
            config.minEvictableIdleTimeMillis = this.connectionPoolingProfile.getMinEvictionMillis();
        }
        this.connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new Neo4jConnectorConnectionFactory(this), config);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    @Override
    public Neo4jConnectorConnectionIdentifierAdapter acquireConnection(Neo4jConnectorConnectionKey key) throws Exception {
        return (Neo4jConnectorConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(Neo4jConnectorConnectionKey key, Neo4jConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(Neo4jConnectorConnectionKey key, Neo4jConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    @Override
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == Capability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    @Override
    public <P> ProcessTemplate<P, Neo4jConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new ManagedConnectionProcessTemplate(this, this.muleContext);
    }

    @Override
    public Neo4jConnectorConnectionKey getDefaultConnectionKey() {
        return new Neo4jConnectorConnectionKey(this.getBaseUri());
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    @Override
    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    @Override
    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        Neo4jConnectorConnectionIdentifierAdapter connection = null;
        Neo4jConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = (DefaultTestResult)this.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }

    public DefaultResult buildFailureTestResult(Exception exception) {
        ConnectionExceptionCode code;
        DefaultTestResult result = exception instanceof ConnectionException ? ((code = ((ConnectionException)exception).getCode()) == ConnectionExceptionCode.UNKNOWN_HOST ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNKNOWN_HOST, (Throwable)exception) : (code == ConnectionExceptionCode.CANNOT_REACH ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.RESOURCE_UNAVAILABLE, (Throwable)exception) : (code == ConnectionExceptionCode.INCORRECT_CREDENTIALS ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.CREDENTIALS_EXPIRED ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.UNKNOWN ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception)))))) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception);
        return result;
    }
}

