/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.neo4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.callback.SourceCallback;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transport.Connector;
import org.mule.modules.neo4j.model.BaseEntity;
import org.mule.modules.neo4j.model.BatchJob;
import org.mule.modules.neo4j.model.BatchJobResult;
import org.mule.modules.neo4j.model.ConfigurableBatchJob;
import org.mule.modules.neo4j.model.CypherQuery;
import org.mule.modules.neo4j.model.CypherQueryParams;
import org.mule.modules.neo4j.model.CypherQueryResult;
import org.mule.modules.neo4j.model.Data;
import org.mule.modules.neo4j.model.Fullpath;
import org.mule.modules.neo4j.model.Index;
import org.mule.modules.neo4j.model.IndexConfiguration;
import org.mule.modules.neo4j.model.IndexedNode;
import org.mule.modules.neo4j.model.IndexedRelationship;
import org.mule.modules.neo4j.model.NewIndex;
import org.mule.modules.neo4j.model.NewRelationship;
import org.mule.modules.neo4j.model.NewSchemaIndex;
import org.mule.modules.neo4j.model.NewUniqueNode;
import org.mule.modules.neo4j.model.NewUniqueRelationship;
import org.mule.modules.neo4j.model.Node;
import org.mule.modules.neo4j.model.NodeIndexingRequest;
import org.mule.modules.neo4j.model.Path;
import org.mule.modules.neo4j.model.PathQuery;
import org.mule.modules.neo4j.model.PathQueryResult;
import org.mule.modules.neo4j.model.Relationship;
import org.mule.modules.neo4j.model.RelationshipQuery;
import org.mule.modules.neo4j.model.SchemaIndex;
import org.mule.modules.neo4j.model.ServiceRoot;
import org.mule.modules.neo4j.model.TraversalQuery;
import org.mule.modules.neo4j.model.TraversalScript;
import org.mule.transport.http.HttpConstants;
import org.mule.util.CaseInsensitiveHashMap;
import org.mule.util.CollectionUtils;
import org.mule.util.IOUtils;
import org.mule.util.MapUtils;
import org.mule.util.StringUtils;

public class Neo4jConnector
implements MuleContextAware {
    private static final TypeReference<ServiceRoot> SERVICE_ROOT_TYPE_REFERENCE = new TypeReference<ServiceRoot>(){};
    private static final TypeReference<CypherQueryResult> CYPHER_QUERY_RESULT_TYPE_REFERENCE = new TypeReference<CypherQueryResult>(){};
    private static final TypeReference<Node> NODE_TYPE_REFERENCE = new TypeReference<Node>(){};
    private static final TypeReference<Collection<Node>> NODES_TYPE_REFERENCE = new TypeReference<Collection<Node>>(){};
    private static final TypeReference<Relationship> RELATIONSHIP_TYPE_REFERENCE = new TypeReference<Relationship>(){};
    private static final TypeReference<Collection<Relationship>> RELATIONSHIPS_TYPE_REFERENCE = new TypeReference<Collection<Relationship>>(){};
    private static final TypeReference<Collection<String>> STRINGS_TYPE_REFERENCE = new TypeReference<Collection<String>>(){};
    private static final TypeReference<SchemaIndex> SCHEMA_INDEX_TYPE_REFERENCE = new TypeReference<SchemaIndex>(){};
    private static final TypeReference<Collection<SchemaIndex>> SCHEMA_INDEXES_TYPE_REFERENCE = new TypeReference<Collection<SchemaIndex>>(){};
    private static final TypeReference<Index> INDEX_TYPE_REFERENCE = new TypeReference<Index>(){};
    private static final TypeReference<Map<String, Map<String, String>>> NODE_INDEXES_TYPE_REFERENCE = new TypeReference<Map<String, Map<String, String>>>(){};
    private static final TypeReference<IndexedNode> INDEXED_NODE_TYPE_REFERENCE = new TypeReference<IndexedNode>(){};
    private static final TypeReference<Collection<IndexedNode>> INDEXED_NODES_TYPE_REFERENCE = new TypeReference<Collection<IndexedNode>>(){};
    private static final TypeReference<IndexedRelationship> INDEXED_RELATIONSHIP_TYPE_REFERENCE = new TypeReference<IndexedRelationship>(){};
    private static final TypeReference<Collection<Path>> PATHS_TYPE_REFERENCE = new TypeReference<Collection<Path>>(){};
    private static final TypeReference<Collection<Fullpath>> FULLPATHS_TYPE_REFERENCE = new TypeReference<Collection<Fullpath>>(){};
    private static final TypeReference<PathQueryResult> PATH_QUERY_RESULT_TYPE_REFERENCE = new TypeReference<PathQueryResult>(){};
    private static final TypeReference<Collection<PathQueryResult>> PATH_QUERY_RESULTS_TYPE_REFERENCE = new TypeReference<Collection<PathQueryResult>>(){};
    private static final TypeReference<Collection<BatchJobResult>> BATCH_JOB_RESULTS_TYPE_REFERENCE = new TypeReference<Collection<BatchJobResult>>(){};
    private static final TypeReference<Boolean> BOOLEAN_TYPE_REFERENCE = new TypeReference<Boolean>(){};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Log LOGGER = LogFactory.getLog(Neo4jConnector.class);
    private static final Set<Integer> SC_OK = Collections.singleton(200);
    private static final Set<Integer> SC_CREATED = Collections.singleton(201);
    private static final Set<Integer> SC_NO_CONTENT = Collections.singleton(204);
    private static final Set<Integer> SC_NO_CONTENT_OR_NOT_FOUND = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(204, 404)));
    private static final Set<Integer> SC_OK_OR_NOT_FOUND = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(200, 404)));
    private static final Set<Integer> SC_OK_OR_NO_CONTENT = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(200, 204)));
    private static final Set<Integer> SC_OK_OR_CREATED = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(200, 201)));
    private static final Set<Integer> NO_RESPONSE_STATUSES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(204, 404)));
    private static final Set<String> ENTITY_CARRYING_HTTP_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("POST", "PUT", "PATCH")));
    private static final String HEADER_STREAMING = "X-Stream";
    private static final String PROPERTY_KEY_TEMPLATE = "{key}";
    private static final String LABEL_TEMPLATE = "{label}";
    private static final String TYPE_LIST_TEMPLATE = "{-list|&|types}";
    private static final String RETURN_TYPE_TEMPLATE = "{returnType}";
    private static final String PAGINATION_PARAMS_TEMPLATE = "{?pageSize,leaseTime}";
    private static final String CREATE_OR_FAIL_UNIQUENESS = "create_or_fail";
    private static final String GET_OR_CREATE_UNIQUENESS = "get_or_create";
    private String user;
    private String password;
    private boolean streaming;
    private Connector connector;
    private MuleContext muleContext;
    private String authorization;
    private String baseUri;
    private ServiceRoot serviceRoot;

    public void connect(String baseUri) throws ConnectionException {
        try {
            new URI(baseUri);
        }
        catch (URISyntaxException urie) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN_HOST, null, "Invalid baseUri: " + baseUri, (Throwable)urie);
        }
        this.baseUri = baseUri;
        try {
            this.serviceRoot = this.getEntity(baseUri + "/", SERVICE_ROOT_TYPE_REFERENCE, SC_OK, new Object[0]);
            String serviceRootSelf = StringUtils.substringBeforeLast((String)this.serviceRoot.getNode(), (String)"/node");
            this.serviceRoot.setRelationship(serviceRootSelf + "/relationship");
            this.serviceRoot.setNodeAutoIndex(StringUtils.replace((String)this.serviceRoot.getNodeIndex(), (String)"index/node", (String)"index/auto/node"));
            if (!this.isBeforeVersion2()) {
                this.serviceRoot.setNodeLabels(serviceRootSelf + "/labels");
                this.serviceRoot.setLabelNodes(serviceRootSelf + "/label/" + LABEL_TEMPLATE + "/nodes");
                this.serviceRoot.setSchemaIndex(serviceRootSelf + "/schema/index/" + LABEL_TEMPLATE);
            }
        }
        catch (MuleException me) {
            throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, null, "Failed to retrieve service root from: " + baseUri, (Throwable)me);
        }
    }

    public boolean isConnected() {
        return this.serviceRoot != null;
    }

    public void disconnect() throws IOException {
        this.serviceRoot = null;
    }

    private String getNodeUri(long nodeId) {
        return this.serviceRoot.getNode() + "/" + nodeId;
    }

    private String getRelationshipUri(long relationshipId) {
        return this.serviceRoot.getRelationship() + "/" + relationshipId;
    }

    private String getSchemaIndexUri(String label) {
        return StringUtils.replace((String)this.serviceRoot.getSchemaIndex(), (String)LABEL_TEMPLATE, (String)label);
    }

    private String getNodeIndexUri(String indexName) {
        return this.serviceRoot.getNodeIndex() + "/" + indexName;
    }

    private String getRelationshipIndexUri(String relationshipName) {
        return this.serviceRoot.getRelationshipIndex() + "/" + relationshipName;
    }

    private String getAutoIndexingStatusUri() {
        return this.serviceRoot.getNodeAutoIndex() + "/status";
    }

    private String getAutoIndexingPropertiesUri() {
        return this.serviceRoot.getNodeAutoIndex() + "/properties";
    }

    private <T> T getEntity(String uri, TypeReference<T> responseType, Set<Integer> expectedStatusCodes, Object ... queryParameters) throws MuleException {
        return this.sendHttpRequest(uri, null, this.getRequestProperties("GET"), responseType, expectedStatusCodes, queryParameters).getEntity();
    }

    private void deleteEntity(String uri, Set<Integer> expectedStatusCodes) throws MuleException {
        this.sendHttpRequest(uri, null, this.getRequestProperties("DELETE"), null, expectedStatusCodes, new Object[0]);
    }

    private <T> T postEntity(String uri, Object entity, TypeReference<T> responseType, Set<Integer> expectedStatusCodes, Object ... queryParameters) throws MuleException {
        return this.sendRequestWithEntity("POST", uri, entity, responseType, expectedStatusCodes, queryParameters).getEntity();
    }

    private void putEntity(String uri, Object entity, Set<Integer> expectedStatusCodes, Object ... queryParameters) throws MuleException {
        this.sendRequestWithEntity("PUT", uri, entity, null, expectedStatusCodes, queryParameters);
    }

    private IndexedNode postUniqueNodeEntity(String indexName, String key, String value, Map<String, Object> properties, String uniqueness, Set<Integer> expectedStatusCodes) throws MuleException {
        Data data = Neo4jConnector.convertMapToData(properties);
        NewUniqueNode newUniqueNode = new NewUniqueNode().withKey(key).withValue(value).withProperties(data);
        return this.postEntity(this.getNodeIndexUri(indexName), newUniqueNode, INDEXED_NODE_TYPE_REFERENCE, expectedStatusCodes, "uniqueness", uniqueness);
    }

    private IndexedRelationship postUniqueRelationshipEntity(String relationshipName, String type, String key, String value, Node startNode, Node endNode, String uniqueness, Set<Integer> expectedStatusCodes) throws MuleException {
        NewUniqueRelationship newUniqueRelationship = new NewUniqueRelationship().withType(type).withKey(key).withValue(value).withStart(startNode.getSelf()).withEnd(endNode.getSelf());
        return this.postEntity(this.getRelationshipIndexUri(relationshipName), newUniqueRelationship, INDEXED_RELATIONSHIP_TYPE_REFERENCE, expectedStatusCodes, "uniqueness", uniqueness);
    }

    private <T> HttpResponse<T> sendRequestWithEntity(String httpMethod, String uri, Object entity, TypeReference<T> responseType, Set<Integer> expectedStatusCodes, Object ... queryParameters) throws MuleException {
        Validate.isTrue((boolean)ENTITY_CARRYING_HTTP_METHODS.contains(httpMethod), (String)("Only entity carrying HTTP methods are supported: " + ENTITY_CARRYING_HTTP_METHODS));
        Map<String, Object> requestProperties = this.getRequestProperties(httpMethod);
        requestProperties.put("Content-Type", "application/json");
        String json = this.serializeEntityToJson(entity);
        return this.sendHttpRequest(uri, json, requestProperties, responseType, expectedStatusCodes, queryParameters);
    }

    private String serializeEntityToJson(Object entity) throws MuleException {
        if (entity == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(entity);
        }
        catch (IOException ioe) {
            throw new DefaultMuleException("Failed to serialize to JSON: " + entity, (Throwable)ioe);
        }
    }

    private <T> HttpResponse<T> sendHttpRequest(String uri, String jsonEntityOrNull, Map<String, Object> requestProperties, TypeReference<T> responseType, Set<Integer> expectedStatusCodes, Object ... queryParameters) throws MuleException {
        Integer responseStatusCode;
        String fullUri = this.buildUri(uri, queryParameters);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Sending HTTP request:%n  URI: %s%n  JSON Entity: %s%n  Request Properties: %s%n  Response Type: %s%n  Expected Status Codes: %s", fullUri, jsonEntityOrNull, requestProperties, responseType == null ? null : responseType.getType(), expectedStatusCodes));
        }
        MuleMessage response = this.muleContext.getClient().send(fullUri, (Object)jsonEntityOrNull, requestProperties);
        CaseInsensitiveHashMap responseHeaders = new CaseInsensitiveHashMap();
        for (String headerName : response.getInboundPropertyNames()) {
            if (!HttpConstants.RESPONSE_HEADER_NAMES.containsKey(headerName)) continue;
            responseHeaders.put(headerName, response.getInboundProperty(headerName));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Received HTTP response: " + response));
        }
        if (!expectedStatusCodes.contains(responseStatusCode = Integer.valueOf((String)response.getInboundProperty("http.status")))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Received payload with unexpected status: " + Neo4jConnector.renderMessageAsString(response)));
            }
            throw new DefaultMuleException("Received status code: " + responseStatusCode + " but was expecting: " + expectedStatusCodes);
        }
        if (NO_RESPONSE_STATUSES.contains(responseStatusCode)) {
            return new HttpResponse<Object>(null, (Map<String, String>)responseHeaders);
        }
        T entity = this.deserializeJsonToEntity(responseType, response);
        return new HttpResponse<T>(entity, (Map<String, String>)responseHeaders);
    }

    private <T> T deserializeJsonToEntity(TypeReference<T> responseType, MuleMessage response) throws MuleException {
        try {
            Object entity;
            if (LOGGER.isDebugEnabled()) {
                response.setPayload((Object)IOUtils.toByteArray((InputStream)((InputStream)response.getPayload())));
                entity = OBJECT_MAPPER.readValue((byte[])response.getPayload(), responseType);
            } else {
                entity = OBJECT_MAPPER.readValue((InputStream)response.getPayload(), responseType);
            }
            if (entity instanceof BaseEntity) {
                BaseEntity baseEntity = (BaseEntity)entity;
                baseEntity.setId(StringUtils.substringAfterLast((String)baseEntity.getSelf(), (String)"/"));
                if (baseEntity instanceof Node) {
                    Node node = (Node)baseEntity;
                    node.setPath(baseEntity.getSelf() + "/path");
                    node.setPaths(baseEntity.getSelf() + "/paths");
                }
            }
            return (T)entity;
        }
        catch (IOException ioe) {
            throw new DefaultMuleException("Failed to deserialize to: " + responseType.getType() + " from: " + Neo4jConnector.renderMessageAsString(response), (Throwable)ioe);
        }
    }

    private static String renderMessageAsString(MuleMessage message) {
        try {
            return message.getPayloadAsString();
        }
        catch (Exception e) {
            return message.toString();
        }
    }

    private String buildUri(String uri, Object ... queryParameters) {
        Validate.isTrue((queryParameters.length % 2 == 0 ? 1 : 0) != 0, (String)"queryParameters must be an even array");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.connector != null) {
            queryParams.put("connector", this.connector.getName());
        }
        for (int i = 0; i < queryParameters.length; i += 2) {
            String name = (String)queryParameters[i];
            Object value = queryParameters[i + 1];
            if (!StringUtils.isNotBlank((String)name) || value == null) continue;
            queryParams.put(name, value.toString());
        }
        if (queryParams.isEmpty()) {
            return uri;
        }
        StringBuilder queryBuilder = new StringBuilder();
        for (Map.Entry queryParam : queryParams.entrySet()) {
            queryBuilder.append(queryBuilder.length() != 0 ? "&" : "?").append(Neo4jConnector.urlEncode((String)queryParam.getKey())).append("=").append(Neo4jConnector.urlEncode((String)queryParam.getValue()));
        }
        return uri + queryBuilder.toString();
    }

    private static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new MuleRuntimeException((Throwable)uee);
        }
    }

    private Map<String, Object> getRequestProperties(String method) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("http.method", method);
        properties.put(HEADER_STREAMING, this.streaming);
        if (StringUtils.isNotBlank((String)this.authorization)) {
            properties.put("Authorization", this.authorization);
        }
        return properties;
    }

    private void deleteEntity(BaseEntity entity, boolean failIfNotFound) throws MuleException {
        this.deleteEntityByUri(entity.getSelf(), failIfNotFound);
    }

    private void deleteEntityByUri(String entityUri, boolean failIfNotFound) throws MuleException {
        this.deleteEntity(entityUri, failIfNotFound ? SC_NO_CONTENT : SC_NO_CONTENT_OR_NOT_FOUND);
    }

    private void setPropertiesOnEntity(Map<String, Object> properties, BaseEntity entity) throws MuleException {
        this.putEntity(entity.getProperties(), properties, SC_NO_CONTENT, new Object[0]);
    }

    private void setPropertyOnEntity(String key, Object value, BaseEntity entity) throws MuleException {
        this.putEntity(StringUtils.replace((String)entity.getProperty(), (String)PROPERTY_KEY_TEMPLATE, (String)key), value, SC_NO_CONTENT, new Object[0]);
    }

    private void deletePropertiesFromEntity(BaseEntity entity) throws MuleException {
        this.deleteEntity(entity.getProperties(), SC_NO_CONTENT);
    }

    private void deletePropertyFromEntity(String key, BaseEntity entity, boolean failIfNotFound) throws MuleException {
        this.deleteEntity(StringUtils.replace((String)entity.getProperty(), (String)PROPERTY_KEY_TEMPLATE, (String)key), failIfNotFound ? SC_NO_CONTENT : SC_NO_CONTENT_OR_NOT_FOUND);
    }

    private static Data convertMapToData(Map<String, Object> properties) {
        Data data = new Data();
        if (MapUtils.isNotEmpty(properties)) {
            data.getAdditionalProperties().putAll(properties);
        }
        return data;
    }

    private boolean isBeforeVersion2() {
        return this.serviceRoot.getNeo4jVersion().compareTo("2") < 0;
    }

    private void ensureVersion2OrAbove() throws DefaultMuleException {
        if (this.isBeforeVersion2()) {
            throw new DefaultMuleException("This feature is only available with Neo4j version 2.0 or above");
        }
    }

    private void logDeprecatedIn2OrAbove(String method) {
        if (!this.isBeforeVersion2()) {
            LOGGER.info((Object)(method + " is deprecated in Neo4j version 2.0 or above"));
        }
    }

    public ServiceRoot getServiceRoot() {
        return this.serviceRoot;
    }

    public CypherQueryResult runCypherQuery(String query, Map<String, Object> params, boolean includeStatistics, boolean profile) throws MuleException {
        CypherQuery cypherQuery = new CypherQuery().withQuery(query);
        if (MapUtils.isNotEmpty(params)) {
            CypherQueryParams cypherQueryParams = new CypherQueryParams();
            cypherQueryParams.getAdditionalProperties().putAll(params);
            cypherQuery.setParams(cypherQueryParams);
        }
        return this.postEntity(this.serviceRoot.getCypher(), cypherQuery, CYPHER_QUERY_RESULT_TYPE_REFERENCE, SC_OK, "includeStats", includeStatistics, "profile", profile);
    }

    public Node getNodeById(long nodeId, boolean failIfNotFound) throws MuleException {
        return this.getEntity(this.getNodeUri(nodeId), NODE_TYPE_REFERENCE, failIfNotFound ? SC_OK : SC_OK_OR_NOT_FOUND, new Object[0]);
    }

    public Node createNode(Map<String, Object> properties) throws MuleException {
        return this.postEntity(this.serviceRoot.getNode(), properties, NODE_TYPE_REFERENCE, SC_CREATED, new Object[0]);
    }

    public IndexedNode getOrCreateUniqueNode(String indexName, String key, String value, Map<String, Object> properties) throws MuleException {
        return this.postUniqueNodeEntity(indexName, key, value, properties, GET_OR_CREATE_UNIQUENESS, SC_OK_OR_CREATED);
    }

    public IndexedNode createUniqueNodeOrFail(String indexName, String key, String value, Map<String, Object> properties) throws MuleException {
        return this.postUniqueNodeEntity(indexName, key, value, properties, CREATE_OR_FAIL_UNIQUENESS, SC_CREATED);
    }

    public void setNodeProperties(Node node, Map<String, Object> properties) throws MuleException {
        this.setPropertiesOnEntity(properties, node);
    }

    public void setNodeProperty(Node node, String key, Object value) throws MuleException {
        this.setPropertyOnEntity(key, value, node);
    }

    public void deleteNodeProperty(Node node, String key, boolean failIfNotFound) throws MuleException {
        this.deletePropertyFromEntity(key, node, failIfNotFound);
    }

    public void deleteNodeProperties(Node node) throws MuleException {
        this.deletePropertiesFromEntity(node);
    }

    public void deleteNodeById(long nodeId, boolean failIfNotFound) throws MuleException {
        this.deleteEntityByUri(this.getNodeUri(nodeId), failIfNotFound);
    }

    @Inject
    public void deleteNode(Node node, boolean failIfNotFound) throws MuleException {
        this.deleteEntity(node, failIfNotFound);
    }

    public Relationship getRelationshipById(long relationshipId, boolean failIfNotFound) throws MuleException {
        return this.getEntity(this.getRelationshipUri(relationshipId), RELATIONSHIP_TYPE_REFERENCE, failIfNotFound ? SC_OK : SC_OK_OR_NOT_FOUND, new Object[0]);
    }

    public Relationship createRelationship(Node fromNode, Node toNode, String type, Map<String, Object> properties) throws MuleException {
        Data data = Neo4jConnector.convertMapToData(properties);
        NewRelationship newRelationship = new NewRelationship().withType(type).withTo(toNode.getSelf()).withData(data);
        return this.postEntity(fromNode.getCreateRelationship(), newRelationship, RELATIONSHIP_TYPE_REFERENCE, SC_CREATED, new Object[0]);
    }

    public IndexedRelationship getOrCreateUniqueRelationship(String relationshipName, String type, String key, String value, Node startNode, Node endNode) throws MuleException {
        return this.postUniqueRelationshipEntity(relationshipName, type, key, value, startNode, endNode, GET_OR_CREATE_UNIQUENESS, SC_OK_OR_CREATED);
    }

    public IndexedRelationship createUniqueRelationshipOrFail(String relationshipName, String type, String key, String value, Node startNode, Node endNode) throws MuleException {
        return this.postUniqueRelationshipEntity(relationshipName, type, key, value, startNode, endNode, CREATE_OR_FAIL_UNIQUENESS, SC_CREATED);
    }

    public void deleteRelationshipById(long relationshipId, boolean failIfNotFound) throws MuleException {
        this.deleteEntityByUri(this.getRelationshipUri(relationshipId), failIfNotFound);
    }

    public void deleteRelationship(Relationship relationship, boolean failIfNotFound) throws MuleException {
        this.deleteEntity(relationship, failIfNotFound);
    }

    public void setRelationshipProperties(Relationship relationship, Map<String, Object> properties) throws MuleException {
        this.setPropertiesOnEntity(properties, relationship);
    }

    public void setRelationshipProperty(Relationship relationship, String key, Object value) throws MuleException {
        this.setPropertyOnEntity(key, value, relationship);
    }

    public void deleteRelationshipProperty(Relationship relationship, String key, boolean failIfNotFound) throws MuleException {
        this.deletePropertyFromEntity(key, relationship, failIfNotFound);
    }

    public void deleteRelationshipProperties(Relationship relationship) throws MuleException {
        this.deletePropertiesFromEntity(relationship);
    }

    public Collection<Relationship> getNodeRelationships(Node node, RelationshipDirection direction, List<String> types) throws MuleException {
        String relationshipsUri;
        if (CollectionUtils.isEmpty(types)) {
            relationshipsUri = direction.getRelationshipsUri(node);
        } else {
            String relationshipsUriPattern = direction.getTypeRelationshipsUriPattern(node);
            relationshipsUri = StringUtils.replace((String)relationshipsUriPattern, (String)TYPE_LIST_TEMPLATE, (String)StringUtils.join(types, (char)'&'));
        }
        return this.getEntity(relationshipsUri, RELATIONSHIPS_TYPE_REFERENCE, SC_OK, new Object[0]);
    }

    public Collection<String> getRelationshipTypes() throws MuleException {
        return this.getEntity(this.getServiceRoot().getRelationshipTypes(), STRINGS_TYPE_REFERENCE, SC_OK, new Object[0]);
    }

    public void addNodeLabel(Node node, String label) throws MuleException {
        this.ensureVersion2OrAbove();
        this.postEntity(node.getLabels(), label, null, SC_NO_CONTENT, new Object[0]);
    }

    public void addNodeLabels(Node node, List<String> labels) throws MuleException {
        this.ensureVersion2OrAbove();
        this.postEntity(node.getLabels(), labels, null, SC_NO_CONTENT, new Object[0]);
    }

    public void setNodeLabels(Node node, List<String> labels) throws MuleException {
        this.ensureVersion2OrAbove();
        this.putEntity(node.getLabels(), labels, SC_NO_CONTENT, new Object[0]);
    }

    public void deleteNodeLabel(Node node, String label) throws MuleException {
        this.ensureVersion2OrAbove();
        this.deleteEntityByUri(node.getLabels() + "/" + label, true);
    }

    public Collection<String> getNodeLabels(Node node) throws MuleException {
        this.ensureVersion2OrAbove();
        return this.getEntity(node.getLabels(), STRINGS_TYPE_REFERENCE, SC_OK, new Object[0]);
    }

    public Collection<Node> getNodesByLabel(String label, String propertyName, Object propertyValue) throws MuleException {
        this.ensureVersion2OrAbove();
        String uri = StringUtils.replace((String)this.serviceRoot.getLabelNodes(), (String)LABEL_TEMPLATE, (String)label);
        return this.getEntity(uri, NODES_TYPE_REFERENCE, SC_OK_OR_NOT_FOUND, propertyName, this.serializeEntityToJson(propertyValue));
    }

    public Collection<String> getLabels() throws MuleException {
        this.ensureVersion2OrAbove();
        return this.getEntity(this.getServiceRoot().getNodeLabels(), STRINGS_TYPE_REFERENCE, SC_OK, new Object[0]);
    }

    public SchemaIndex createSchemaIndex(String label, List<String> propertyKeys) throws MuleException {
        this.ensureVersion2OrAbove();
        Validate.notEmpty(propertyKeys, (String)"propertyKeys can not be empty");
        return this.postEntity(this.getSchemaIndexUri(label), new NewSchemaIndex().withPropertyKeys(propertyKeys), SCHEMA_INDEX_TYPE_REFERENCE, SC_OK, new Object[0]);
    }

    public Collection<SchemaIndex> getSchemaIndexes(String label) throws MuleException {
        this.ensureVersion2OrAbove();
        return this.getEntity(this.getSchemaIndexUri(label), SCHEMA_INDEXES_TYPE_REFERENCE, SC_OK, new Object[0]);
    }

    public void deleteSchemaIndex(String label, String propertyKey, boolean failIfNotFound) throws MuleException {
        this.ensureVersion2OrAbove();
        this.deleteEntityByUri(this.getSchemaIndexUri(label) + "/" + propertyKey, failIfNotFound);
    }

    private Index createLegacyIndex(String indexUri, String indexName, String type, String provider) throws MuleException {
        NewIndex newNodeIndex = new NewIndex().withName(indexName);
        if (StringUtils.isNotBlank((String)type) || StringUtils.isNotBlank((String)provider)) {
            newNodeIndex.setConfig(new IndexConfiguration().withType(type).withProvider(provider));
        }
        Index nodeIndex = this.postEntity(indexUri, newNodeIndex, INDEX_TYPE_REFERENCE, SC_CREATED, new Object[0]);
        nodeIndex.setName(indexName);
        return nodeIndex;
    }

    @Deprecated
    public Index createNodeIndex(String indexName, String type, String provider) throws MuleException {
        this.logDeprecatedIn2OrAbove("createNodeIndex");
        return this.createLegacyIndex(this.serviceRoot.getNodeIndex(), indexName, type, provider);
    }

    @Deprecated
    public void deleteNodeIndex(String indexName, boolean failIfNotFound) throws MuleException {
        this.logDeprecatedIn2OrAbove("deleteNodeIndex");
        this.deleteEntityByUri(this.getNodeIndexUri(indexName), failIfNotFound);
    }

    private Collection<Index> getLegacyIndexes(String indexUri) throws MuleException {
        Map<String, Map<String, String>> rawNodeIndexes = this.getEntity(indexUri, NODE_INDEXES_TYPE_REFERENCE, SC_OK_OR_NO_CONTENT, new Object[0]);
        ArrayList<Index> nodeIndexes = new ArrayList<Index>();
        if (MapUtils.isNotEmpty(rawNodeIndexes)) {
            for (Map.Entry<String, Map<String, String>> rawNodeIndex : rawNodeIndexes.entrySet()) {
                Index nodeIndex = new Index().withName(rawNodeIndex.getKey());
                nodeIndex.setTemplate(rawNodeIndex.getValue().get("template"));
                nodeIndex.setProvider(rawNodeIndex.getValue().get("provider"));
                nodeIndex.setType(rawNodeIndex.getValue().get("type"));
                nodeIndexes.add(nodeIndex);
            }
        }
        return nodeIndexes;
    }

    @Deprecated
    public Collection<Index> getNodeIndexes() throws MuleException {
        this.logDeprecatedIn2OrAbove("getNodeIndexes");
        return this.getLegacyIndexes(this.serviceRoot.getNodeIndex());
    }

    @Deprecated
    public IndexedNode addNodeToIndex(String indexName, Node node, String key, String value) throws MuleException {
        this.logDeprecatedIn2OrAbove("addNodeToIndex");
        NodeIndexingRequest nodeIndexingRequest = new NodeIndexingRequest().withKey(key).withValue(value).withUri(node.getSelf());
        return this.postEntity(this.getNodeIndexUri(indexName), nodeIndexingRequest, INDEXED_NODE_TYPE_REFERENCE, SC_CREATED, new Object[0]);
    }

    @Deprecated
    public void removeNodeIndexEntries(String indexName, Node node, String key, String value, boolean failIfNotFound) throws MuleException {
        this.logDeprecatedIn2OrAbove("removeNodeIndexEntries");
        StringBuilder uriBuilder = new StringBuilder(this.getNodeIndexUri(indexName));
        if (StringUtils.isNotBlank((String)key)) {
            uriBuilder.append("/").append(key);
            if (StringUtils.isNotBlank((String)value)) {
                uriBuilder.append("/").append(value);
            }
        }
        uriBuilder.append("/").append(node.getId());
        this.deleteEntityByUri(uriBuilder.toString(), failIfNotFound);
    }

    @Deprecated
    public Collection<IndexedNode> findNodesByIndex(String indexName, String key, String value) throws MuleException {
        this.logDeprecatedIn2OrAbove("findNodesByIndex");
        return this.getEntity(this.getNodeIndexUri(indexName) + "/" + key + "/" + value, INDEXED_NODES_TYPE_REFERENCE, SC_OK, new Object[0]);
    }

    @Deprecated
    public Collection<IndexedNode> findNodesByAutoIndex(String key, String value) throws MuleException {
        this.logDeprecatedIn2OrAbove("findNodesByAutoIndex");
        return this.getEntity(this.getServiceRoot().getNodeAutoIndex() + "/" + key + "/" + value, INDEXED_NODES_TYPE_REFERENCE, SC_OK, new Object[0]);
    }

    @Deprecated
    public Collection<IndexedNode> findNodesByQuery(String indexName, String query, QueryResultOrder order) throws MuleException {
        this.logDeprecatedIn2OrAbove("findNodesByIndex");
        return this.getEntity(this.getNodeIndexUri(indexName), INDEXED_NODES_TYPE_REFERENCE, SC_OK, "query", query, "order", order == null ? null : order.toString().toLowerCase());
    }

    @Deprecated
    public Collection<IndexedNode> findNodesByAutoIndexQuery(String query) throws MuleException {
        this.logDeprecatedIn2OrAbove("findNodesByAutoIndexQuery");
        return this.getEntity(this.getServiceRoot().getNodeAutoIndex(), INDEXED_NODES_TYPE_REFERENCE, SC_OK, "query", query);
    }

    @Deprecated
    public Index createRelationshipIndex(String indexName, String type, String provider) throws MuleException {
        this.logDeprecatedIn2OrAbove("createRelationshipIndex");
        return this.createLegacyIndex(this.serviceRoot.getRelationshipIndex(), indexName, type, provider);
    }

    @Deprecated
    public Collection<Index> getRelationshipIndexes() throws MuleException {
        this.logDeprecatedIn2OrAbove("getRelationshipIndexes");
        return this.getLegacyIndexes(this.serviceRoot.getRelationshipIndex());
    }

    @Deprecated
    public void deleteRelationshipIndex(String indexName, boolean failIfNotFound) throws MuleException {
        this.logDeprecatedIn2OrAbove("deleteRelationshipIndex");
        this.deleteEntityByUri(this.getRelationshipIndexUri(indexName), failIfNotFound);
    }

    @Deprecated
    public AutoIndexingStatus getAutoindexingStatus() throws MuleException {
        this.logDeprecatedIn2OrAbove("getAutoindexingStatus");
        Boolean isEnabled = this.getEntity(this.getAutoIndexingStatusUri(), BOOLEAN_TYPE_REFERENCE, SC_OK, new Object[0]);
        return isEnabled != false ? AutoIndexingStatus.ENABLED : AutoIndexingStatus.DISABLED;
    }

    @Deprecated
    public void setAutoindexingStatus(AutoIndexingStatus status) throws MuleException {
        this.logDeprecatedIn2OrAbove("setAutoindexingStatus");
        Boolean shouldEnable = status == AutoIndexingStatus.ENABLED ? Boolean.TRUE : Boolean.FALSE;
        this.putEntity(this.getAutoIndexingStatusUri(), shouldEnable, SC_NO_CONTENT, new Object[0]);
    }

    @Deprecated
    public Collection<String> getAutoindexingProperties() throws MuleException {
        this.logDeprecatedIn2OrAbove("getAutoindexingProperties");
        return this.getEntity(this.getAutoIndexingPropertiesUri(), STRINGS_TYPE_REFERENCE, SC_OK, new Object[0]);
    }

    @Deprecated
    public void addAutoindexingProperty(String propertyName) throws MuleException {
        this.logDeprecatedIn2OrAbove("addAutoindexingProperty");
        this.postEntity(this.getAutoIndexingPropertiesUri(), propertyName, null, SC_NO_CONTENT, new Object[0]);
    }

    @Deprecated
    public void deleteAutoindexingProperty(String propertyName) throws MuleException {
        this.logDeprecatedIn2OrAbove("deleteAutoindexingProperty");
        this.deleteEntityByUri(this.getAutoIndexingPropertiesUri() + propertyName, false);
    }

    private <T> Collection<T> traverse(Node node, TraversalQuery.Order order, TraversalQuery.Uniqueness uniqueness, Integer maxDepth, List<RelationshipQuery> relationships, TraversalScript returnFilter, TraversalScript pruneEvaluator, TraversalResult traversalResult, TypeReference<Collection<T>> responseType) throws MuleException {
        String traverseUri = StringUtils.replace((String)node.getTraverse(), (String)RETURN_TYPE_TEMPLATE, (String)traversalResult.toString().toLowerCase());
        TraversalQuery traversalQuery = new TraversalQuery().withOrder(order).withUniqueness(uniqueness).withMaxDepth(maxDepth).withRelationships(relationships).withPruneEvaluator(pruneEvaluator).withReturnFilter(returnFilter);
        return this.postEntity(traverseUri, traversalQuery, responseType, SC_OK, new Object[0]);
    }

    public Collection<Node> traverseForNodes(Node node, TraversalQuery.Order order, TraversalQuery.Uniqueness uniqueness, Integer maxDepth, List<RelationshipQuery> relationships, TraversalScript returnFilter, TraversalScript pruneEvaluator) throws MuleException {
        return this.traverse(node, order, uniqueness, maxDepth, relationships, returnFilter, pruneEvaluator, TraversalResult.NODE, NODES_TYPE_REFERENCE);
    }

    public Collection<Relationship> traverseForRelationships(Node node, TraversalQuery.Order order, TraversalQuery.Uniqueness uniqueness, Integer maxDepth, List<RelationshipQuery> relationships, TraversalScript returnFilter, TraversalScript pruneEvaluator) throws MuleException {
        return this.traverse(node, order, uniqueness, maxDepth, relationships, returnFilter, pruneEvaluator, TraversalResult.RELATIONSHIP, RELATIONSHIPS_TYPE_REFERENCE);
    }

    public Collection<Path> traverseForPaths(Node node, TraversalQuery.Order order, TraversalQuery.Uniqueness uniqueness, Integer maxDepth, List<RelationshipQuery> relationships, TraversalScript returnFilter, TraversalScript pruneEvaluator) throws MuleException {
        return this.traverse(node, order, uniqueness, maxDepth, relationships, returnFilter, pruneEvaluator, TraversalResult.PATH, PATHS_TYPE_REFERENCE);
    }

    public Collection<Fullpath> traverseForFullpaths(Node node, TraversalQuery.Order order, TraversalQuery.Uniqueness uniqueness, Integer maxDepth, List<RelationshipQuery> relationships, TraversalScript returnFilter, TraversalScript pruneEvaluator) throws MuleException {
        return this.traverse(node, order, uniqueness, maxDepth, relationships, returnFilter, pruneEvaluator, TraversalResult.FULLPATH, FULLPATHS_TYPE_REFERENCE);
    }

    private <T> void traversePaged(Node node, TraversalQuery.Order order, TraversalQuery.Uniqueness uniqueness, Integer maxDepth, List<RelationshipQuery> relationships, TraversalScript returnFilter, TraversalScript pruneEvaluator, int pageSize, int leaseTimeSeconds, MuleEvent muleEvent, SourceCallback sourceCallback, TraversalResult traversalResult, TypeReference<Collection<T>> responseType) throws MuleException {
        Collection<T> nextPage;
        String pagedTraverseUri = StringUtils.replace((String)node.getPagedTraverse(), (String)"{returnType}{?pageSize,leaseTime}", (String)traversalResult.toString().toLowerCase());
        TraversalQuery traversalQuery = new TraversalQuery().withOrder(order).withUniqueness(uniqueness).withMaxDepth(maxDepth).withRelationships(relationships).withPruneEvaluator(pruneEvaluator).withReturnFilter(returnFilter);
        HttpResponse<Collection<T>> httpResponse = this.sendRequestWithEntity("POST", pagedTraverseUri, traversalQuery, responseType, SC_CREATED, "pageSize", pageSize, "leaseTime", leaseTimeSeconds);
        DefaultMuleEvent initialResponseEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage(httpResponse.getEntity(), muleEvent.getMessage(), this.muleContext), muleEvent);
        sourceCallback.processEvent((MuleEvent)initialResponseEvent);
        String nextPageUri = httpResponse.getHeaders().get("Location");
        while ((nextPage = this.getEntity(nextPageUri, responseType, SC_OK_OR_NOT_FOUND, new Object[0])) != null) {
            DefaultMuleEvent nextPageResponseEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage(nextPage, muleEvent.getMessage(), this.muleContext), muleEvent);
            sourceCallback.processEvent((MuleEvent)nextPageResponseEvent);
        }
    }

    @Inject
    public void traverseForNodesWithPaging(Node node, TraversalQuery.Order order, TraversalQuery.Uniqueness uniqueness, Integer maxDepth, List<RelationshipQuery> relationships, TraversalScript returnFilter, TraversalScript pruneEvaluator, int pageSize, int leaseTimeSeconds, MuleEvent muleEvent, SourceCallback sourceCallback) throws MuleException {
        this.traversePaged(node, order, uniqueness, maxDepth, relationships, returnFilter, pruneEvaluator, pageSize, leaseTimeSeconds, muleEvent, sourceCallback, TraversalResult.NODE, NODES_TYPE_REFERENCE);
    }

    @Inject
    public void traverseForRelationshipsWithPaging(Node node, TraversalQuery.Order order, TraversalQuery.Uniqueness uniqueness, Integer maxDepth, List<RelationshipQuery> relationships, TraversalScript returnFilter, TraversalScript pruneEvaluator, int pageSize, int leaseTimeSeconds, MuleEvent muleEvent, SourceCallback sourceCallback) throws MuleException {
        this.traversePaged(node, order, uniqueness, maxDepth, relationships, returnFilter, pruneEvaluator, pageSize, leaseTimeSeconds, muleEvent, sourceCallback, TraversalResult.RELATIONSHIP, RELATIONSHIPS_TYPE_REFERENCE);
    }

    @Inject
    public void traverseForPathsWithPaging(Node node, TraversalQuery.Order order, TraversalQuery.Uniqueness uniqueness, Integer maxDepth, List<RelationshipQuery> relationships, TraversalScript returnFilter, TraversalScript pruneEvaluator, int pageSize, int leaseTimeSeconds, MuleEvent muleEvent, SourceCallback sourceCallback) throws MuleException {
        this.traversePaged(node, order, uniqueness, maxDepth, relationships, returnFilter, pruneEvaluator, pageSize, leaseTimeSeconds, muleEvent, sourceCallback, TraversalResult.PATH, PATHS_TYPE_REFERENCE);
    }

    @Inject
    public void traverseForFullpathsWithPaging(Node node, TraversalQuery.Order order, TraversalQuery.Uniqueness uniqueness, Integer maxDepth, List<RelationshipQuery> relationships, TraversalScript returnFilter, TraversalScript pruneEvaluator, int pageSize, int leaseTimeSeconds, MuleEvent muleEvent, SourceCallback sourceCallback) throws MuleException {
        this.traversePaged(node, order, uniqueness, maxDepth, relationships, returnFilter, pruneEvaluator, pageSize, leaseTimeSeconds, muleEvent, sourceCallback, TraversalResult.FULLPATH, FULLPATHS_TYPE_REFERENCE);
    }

    private <T> T traverseWithAlgorithm(Node toNode, PathQuery.Algorithm algorithm, String relationshipType, String costProperty, Double defaultCost, String requestUri, TypeReference<T> responseType, Set<Integer> expectedStatusCodes) throws MuleException {
        PathQuery pathQuery = new PathQuery().withTo(toNode.getSelf()).withAlgorithm(algorithm).withCostProperty(costProperty).withDefaultCost(defaultCost).withRelationships(new RelationshipQuery().withDirection(RelationshipQuery.Direction.OUT).withType(relationshipType));
        return this.postEntity(requestUri, pathQuery, responseType, expectedStatusCodes, new Object[0]);
    }

    public PathQueryResult traverseForPathWithAlgorithm(Node fromNode, Node toNode, PathQuery.Algorithm algorithm, String relationshipType, int maxDepth, String costProperty, Double defaultCost, boolean failIfNotFound) throws MuleException {
        return this.traverseWithAlgorithm(toNode, algorithm, relationshipType, costProperty, defaultCost, fromNode.getPath(), PATH_QUERY_RESULT_TYPE_REFERENCE, failIfNotFound ? SC_OK : SC_OK_OR_NOT_FOUND);
    }

    public Collection<PathQueryResult> traverseForPathsWithAlgorithm(Node fromNode, Node toNode, PathQuery.Algorithm algorithm, String relationshipType, int maxDepth, String costProperty, Double defaultCost) throws MuleException {
        return this.traverseWithAlgorithm(toNode, algorithm, relationshipType, costProperty, defaultCost, fromNode.getPaths(), PATH_QUERY_RESULTS_TYPE_REFERENCE, SC_OK);
    }

    public Collection<BatchJobResult> executeBatch(List<ConfigurableBatchJob> jobs) throws MuleException {
        Validate.notEmpty(jobs, (String)"jobs can not be empty");
        ArrayList<BatchJob> batch = new ArrayList<BatchJob>();
        for (ConfigurableBatchJob job : jobs) {
            batch.add(job.toBatchJob());
        }
        return this.postEntity(this.serviceRoot.getBatch(), batch, BATCH_JOB_RESULTS_TYPE_REFERENCE, SC_OK, new Object[0]);
    }

    private void refreshAuthorization() {
        if (StringUtils.isEmpty((String)this.user) && StringUtils.isEmpty((String)this.password)) {
            return;
        }
        String userPassword = StringUtils.trimToEmpty((String)this.user) + ":" + StringUtils.trimToEmpty((String)this.password);
        byte[] credentialBytes = userPassword.getBytes();
        this.authorization = "Basic " + new String(Base64.encodeBase64((byte[])credentialBytes));
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
        this.refreshAuthorization();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.refreshAuthorization();
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public boolean getStreaming() {
        return this.streaming;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    private static class HttpResponse<T> {
        private final T entity;
        private final Map<String, String> headers;

        public HttpResponse(T entity, Map<String, String> headers) {
            this.entity = entity;
            this.headers = headers;
        }

        public T getEntity() {
            return this.entity;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }

    private static enum TraversalResult {
        NODE,
        RELATIONSHIP,
        PATH,
        FULLPATH;

    }

    public static enum AutoIndexingStatus {
        ENABLED,
        DISABLED;

    }

    public static enum QueryResultOrder {
        INDEX,
        RELEVANCE,
        SCORE;

    }

    public static enum RelationshipDirection {
        ALL{

            @Override
            public String getRelationshipsUri(Node node) {
                return node.getAllRelationships();
            }

            @Override
            public String getTypeRelationshipsUriPattern(Node node) {
                return node.getAllTypedRelationships();
            }
        }
        ,
        IN{

            @Override
            public String getRelationshipsUri(Node node) {
                return node.getIncomingRelationships();
            }

            @Override
            public String getTypeRelationshipsUriPattern(Node node) {
                return node.getIncomingTypedRelationships();
            }
        }
        ,
        OUT{

            @Override
            public String getRelationshipsUri(Node node) {
                return node.getOutgoingRelationships();
            }

            @Override
            public String getTypeRelationshipsUriPattern(Node node) {
                return node.getOutgoingTypedRelationships();
            }
        };


        public abstract String getRelationshipsUri(Node var1);

        public abstract String getTypeRelationshipsUriPattern(Node var1);
    }
}

