
package org.mule.modules.neo4j.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.DefaultResult;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.neo4j.Neo4jConnector;
import org.mule.modules.neo4j.connectivity.Neo4jConnectorConnectionManager;
import org.mule.modules.neo4j.model.Node;
import org.mule.modules.neo4j.model.PathQuery.Algorithm;
import org.mule.modules.neo4j.model.PathQueryResult;
import org.mule.modules.neo4j.process.ProcessAdapter;
import org.mule.modules.neo4j.process.ProcessCallback;
import org.mule.modules.neo4j.process.ProcessTemplate;


/**
 * TraverseForPathWithAlgorithmMessageProcessor invokes the {@link org.mule.modules.neo4j.Neo4jConnector#traverseForPathWithAlgorithm(org.mule.modules.neo4j.model.Node, org.mule.modules.neo4j.model.Node, org.mule.modules.neo4j.model.PathQuery.Algorithm, java.lang.String, int, java.lang.String, java.lang.Double, boolean)} method in {@link Neo4jConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-06-17T03:24:12-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class TraverseForPathWithAlgorithmMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor, OperationMetaDataEnabled
{

    protected Object fromNode;
    protected Node _fromNodeType;
    protected Object toNode;
    protected Node _toNodeType;
    protected Object algorithm;
    protected Algorithm _algorithmType;
    protected Object relationshipType;
    protected String _relationshipTypeType;
    protected Object maxDepth;
    protected int _maxDepthType;
    protected Object costProperty;
    protected String _costPropertyType;
    protected Object defaultCost;
    protected Double _defaultCostType;
    protected Object failIfNotFound;
    protected boolean _failIfNotFoundType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets maxDepth
     * 
     * @param value Value to set
     */
    public void setMaxDepth(Object value) {
        this.maxDepth = value;
    }

    /**
     * Sets relationshipType
     * 
     * @param value Value to set
     */
    public void setRelationshipType(Object value) {
        this.relationshipType = value;
    }

    /**
     * Sets fromNode
     * 
     * @param value Value to set
     */
    public void setFromNode(Object value) {
        this.fromNode = value;
    }

    /**
     * Sets costProperty
     * 
     * @param value Value to set
     */
    public void setCostProperty(Object value) {
        this.costProperty = value;
    }

    /**
     * Sets defaultCost
     * 
     * @param value Value to set
     */
    public void setDefaultCost(Object value) {
        this.defaultCost = value;
    }

    /**
     * Sets toNode
     * 
     * @param value Value to set
     */
    public void setToNode(Object value) {
        this.toNode = value;
    }

    /**
     * Sets failIfNotFound
     * 
     * @param value Value to set
     */
    public void setFailIfNotFound(Object value) {
        this.failIfNotFound = value;
    }

    /**
     * Sets algorithm
     * 
     * @param value Value to set
     */
    public void setAlgorithm(Object value) {
        this.algorithm = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(Neo4jConnectorConnectionManager.class, true, event);
            final Node _transformedFromNode = ((Node) evaluateAndTransform(getMuleContext(), event, TraverseForPathWithAlgorithmMessageProcessor.class.getDeclaredField("_fromNodeType").getGenericType(), null, fromNode));
            final Node _transformedToNode = ((Node) evaluateAndTransform(getMuleContext(), event, TraverseForPathWithAlgorithmMessageProcessor.class.getDeclaredField("_toNodeType").getGenericType(), null, toNode));
            final Algorithm _transformedAlgorithm = ((Algorithm) evaluateAndTransform(getMuleContext(), event, TraverseForPathWithAlgorithmMessageProcessor.class.getDeclaredField("_algorithmType").getGenericType(), null, algorithm));
            final String _transformedRelationshipType = ((String) evaluateAndTransform(getMuleContext(), event, TraverseForPathWithAlgorithmMessageProcessor.class.getDeclaredField("_relationshipTypeType").getGenericType(), null, relationshipType));
            final Integer _transformedMaxDepth = ((Integer) evaluateAndTransform(getMuleContext(), event, TraverseForPathWithAlgorithmMessageProcessor.class.getDeclaredField("_maxDepthType").getGenericType(), null, maxDepth));
            final String _transformedCostProperty = ((String) evaluateAndTransform(getMuleContext(), event, TraverseForPathWithAlgorithmMessageProcessor.class.getDeclaredField("_costPropertyType").getGenericType(), null, costProperty));
            final Double _transformedDefaultCost = ((Double) evaluateAndTransform(getMuleContext(), event, TraverseForPathWithAlgorithmMessageProcessor.class.getDeclaredField("_defaultCostType").getGenericType(), null, defaultCost));
            final Boolean _transformedFailIfNotFound = ((Boolean) evaluateAndTransform(getMuleContext(), event, TraverseForPathWithAlgorithmMessageProcessor.class.getDeclaredField("_failIfNotFoundType").getGenericType(), null, failIfNotFound));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((Neo4jConnector) object).traverseForPathWithAlgorithm(_transformedFromNode, _transformedToNode, _transformedAlgorithm, _transformedRelationshipType, _transformedMaxDepth, _transformedCostProperty, _transformedDefaultCost, _transformedFailIfNotFound);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("traverseForPathWithAlgorithm"), event, e);
        }
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        return new DefaultResult<MetaData>(null, (Result.Status.SUCCESS));
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult<MetaData>(new DefaultMetaData(getPojoOrSimpleModel(PathQueryResult.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals(dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        } else {
            return new DefaultSimpleMetaDataModel(dataType);
        }
    }

}
