
package org.mule.modules.neo4j.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.callback.SourceCallback;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.common.DefaultResult;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.neo4j.Neo4jConnector;
import org.mule.modules.neo4j.connectivity.Neo4jConnectorConnectionManager;
import org.mule.modules.neo4j.model.Node;
import org.mule.modules.neo4j.model.RelationshipQuery;
import org.mule.modules.neo4j.model.TraversalQuery.Order;
import org.mule.modules.neo4j.model.TraversalQuery.Uniqueness;
import org.mule.modules.neo4j.model.TraversalScript;
import org.mule.modules.neo4j.process.ProcessAdapter;
import org.mule.modules.neo4j.process.ProcessCallback;
import org.mule.modules.neo4j.process.ProcessTemplate;


/**
 * TraverseForFullpathsWithPagingMessageProcessor invokes the {@link org.mule.modules.neo4j.Neo4jConnector#traverseForFullpathsWithPaging(org.mule.modules.neo4j.model.Node, org.mule.modules.neo4j.model.TraversalQuery.Order, org.mule.modules.neo4j.model.TraversalQuery.Uniqueness, java.lang.Integer, java.util.List<org.mule.modules.neo4j.model.RelationshipQuery>, org.mule.modules.neo4j.model.TraversalScript, org.mule.modules.neo4j.model.TraversalScript, int, int, org.mule.api.MuleEvent, org.mule.api.callback.SourceCallback)} method in {@link Neo4jConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-06-17T03:24:12-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class TraverseForFullpathsWithPagingMessageProcessor
    extends AbstractListeningMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, InterceptingMessageProcessor, OperationMetaDataEnabled
{

    protected Object node;
    protected Node _nodeType;
    protected Object order;
    protected Order _orderType;
    protected Object uniqueness;
    protected Uniqueness _uniquenessType;
    protected Object maxDepth;
    protected Integer _maxDepthType;
    protected Object relationships;
    protected List<RelationshipQuery> _relationshipsType;
    protected Object returnFilter;
    protected TraversalScript _returnFilterType;
    protected Object pruneEvaluator;
    protected TraversalScript _pruneEvaluatorType;
    protected Object pageSize;
    protected int _pageSizeType;
    protected Object leaseTimeSeconds;
    protected int _leaseTimeSecondsType;
    protected Object muleEvent;
    protected MuleEvent _muleEventType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets maxDepth
     * 
     * @param value Value to set
     */
    public void setMaxDepth(Object value) {
        this.maxDepth = value;
    }

    /**
     * Sets node
     * 
     * @param value Value to set
     */
    public void setNode(Object value) {
        this.node = value;
    }

    /**
     * Sets returnFilter
     * 
     * @param value Value to set
     */
    public void setReturnFilter(Object value) {
        this.returnFilter = value;
    }

    /**
     * Sets order
     * 
     * @param value Value to set
     */
    public void setOrder(Object value) {
        this.order = value;
    }

    /**
     * Sets pageSize
     * 
     * @param value Value to set
     */
    public void setPageSize(Object value) {
        this.pageSize = value;
    }

    /**
     * Sets uniqueness
     * 
     * @param value Value to set
     */
    public void setUniqueness(Object value) {
        this.uniqueness = value;
    }

    /**
     * Sets muleEvent
     * 
     * @param value Value to set
     */
    public void setMuleEvent(Object value) {
        this.muleEvent = value;
    }

    /**
     * Sets leaseTimeSeconds
     * 
     * @param value Value to set
     */
    public void setLeaseTimeSeconds(Object value) {
        this.leaseTimeSeconds = value;
    }

    /**
     * Sets pruneEvaluator
     * 
     * @param value Value to set
     */
    public void setPruneEvaluator(Object value) {
        this.pruneEvaluator = value;
    }

    /**
     * Sets relationships
     * 
     * @param value Value to set
     */
    public void setRelationships(Object value) {
        this.relationships = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        final SourceCallback sourceCallback = this;
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(Neo4jConnectorConnectionManager.class, true, event);
            final Node _transformedNode = ((Node) evaluateAndTransform(getMuleContext(), event, TraverseForFullpathsWithPagingMessageProcessor.class.getDeclaredField("_nodeType").getGenericType(), null, node));
            final Order _transformedOrder = ((Order) evaluateAndTransform(getMuleContext(), event, TraverseForFullpathsWithPagingMessageProcessor.class.getDeclaredField("_orderType").getGenericType(), null, order));
            final Uniqueness _transformedUniqueness = ((Uniqueness) evaluateAndTransform(getMuleContext(), event, TraverseForFullpathsWithPagingMessageProcessor.class.getDeclaredField("_uniquenessType").getGenericType(), null, uniqueness));
            final Integer _transformedMaxDepth = ((Integer) evaluateAndTransform(getMuleContext(), event, TraverseForFullpathsWithPagingMessageProcessor.class.getDeclaredField("_maxDepthType").getGenericType(), null, maxDepth));
            final List<RelationshipQuery> _transformedRelationships = ((List<RelationshipQuery> ) evaluateAndTransform(getMuleContext(), event, TraverseForFullpathsWithPagingMessageProcessor.class.getDeclaredField("_relationshipsType").getGenericType(), null, relationships));
            final TraversalScript _transformedReturnFilter = ((TraversalScript) evaluateAndTransform(getMuleContext(), event, TraverseForFullpathsWithPagingMessageProcessor.class.getDeclaredField("_returnFilterType").getGenericType(), null, returnFilter));
            final TraversalScript _transformedPruneEvaluator = ((TraversalScript) evaluateAndTransform(getMuleContext(), event, TraverseForFullpathsWithPagingMessageProcessor.class.getDeclaredField("_pruneEvaluatorType").getGenericType(), null, pruneEvaluator));
            final Integer _transformedPageSize = ((Integer) evaluateAndTransform(getMuleContext(), event, TraverseForFullpathsWithPagingMessageProcessor.class.getDeclaredField("_pageSizeType").getGenericType(), null, pageSize));
            final Integer _transformedLeaseTimeSeconds = ((Integer) evaluateAndTransform(getMuleContext(), event, TraverseForFullpathsWithPagingMessageProcessor.class.getDeclaredField("_leaseTimeSecondsType").getGenericType(), null, leaseTimeSeconds));
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    ((Neo4jConnector) object).traverseForFullpathsWithPaging(_transformedNode, _transformedOrder, _transformedUniqueness, _transformedMaxDepth, _transformedRelationships, _transformedReturnFilter, _transformedPruneEvaluator, _transformedPageSize, _transformedLeaseTimeSeconds, event, sourceCallback);
                    return null;
                }

            }
            , this, event);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("traverseForFullpathsWithPaging"), event, e);
        }
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        return new DefaultResult<MetaData>(null, (Result.Status.SUCCESS));
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult<MetaData>(new DefaultMetaData(getPojoOrSimpleModel(void.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals(dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        } else {
            return new DefaultSimpleMetaDataModel(dataType);
        }
    }

}
