
package org.mule.modules.neo4j.processors;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.DefaultResult;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.neo4j.Neo4jConnector;
import org.mule.modules.neo4j.connectivity.Neo4jConnectorConnectionManager;
import org.mule.modules.neo4j.model.CypherQueryResult;
import org.mule.modules.neo4j.process.ProcessAdapter;
import org.mule.modules.neo4j.process.ProcessCallback;
import org.mule.modules.neo4j.process.ProcessTemplate;


/**
 * RunCypherQueryMessageProcessor invokes the {@link org.mule.modules.neo4j.Neo4jConnector#runCypherQuery(java.lang.String, java.util.Map, boolean, boolean)} method in {@link Neo4jConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-06-17T03:24:12-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class RunCypherQueryMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor, OperationMetaDataEnabled
{

    protected Object query;
    protected String _queryType;
    protected Object params;
    protected Map<String, Object> _paramsType;
    protected Object includeStatistics;
    protected boolean _includeStatisticsType;
    protected Object profile;
    protected boolean _profileType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets query
     * 
     * @param value Value to set
     */
    public void setQuery(Object value) {
        this.query = value;
    }

    /**
     * Sets params
     * 
     * @param value Value to set
     */
    public void setParams(Object value) {
        this.params = value;
    }

    /**
     * Sets includeStatistics
     * 
     * @param value Value to set
     */
    public void setIncludeStatistics(Object value) {
        this.includeStatistics = value;
    }

    /**
     * Sets profile
     * 
     * @param value Value to set
     */
    public void setProfile(Object value) {
        this.profile = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(Neo4jConnectorConnectionManager.class, true, event);
            final String _transformedQuery = ((String) evaluateAndTransform(getMuleContext(), event, RunCypherQueryMessageProcessor.class.getDeclaredField("_queryType").getGenericType(), null, query));
            final Map<String, Object> _transformedParams = ((Map<String, Object> ) evaluateAndTransform(getMuleContext(), event, RunCypherQueryMessageProcessor.class.getDeclaredField("_paramsType").getGenericType(), null, params));
            final Boolean _transformedIncludeStatistics = ((Boolean) evaluateAndTransform(getMuleContext(), event, RunCypherQueryMessageProcessor.class.getDeclaredField("_includeStatisticsType").getGenericType(), null, includeStatistics));
            final Boolean _transformedProfile = ((Boolean) evaluateAndTransform(getMuleContext(), event, RunCypherQueryMessageProcessor.class.getDeclaredField("_profileType").getGenericType(), null, profile));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((Neo4jConnector) object).runCypherQuery(_transformedQuery, _transformedParams, _transformedIncludeStatistics, _transformedProfile);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("runCypherQuery"), event, e);
        }
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        return new DefaultResult<MetaData>(null, (Result.Status.SUCCESS));
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult<MetaData>(new DefaultMetaData(getPojoOrSimpleModel(CypherQueryResult.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals(dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        } else {
            return new DefaultSimpleMetaDataModel(dataType);
        }
    }

}
