
package org.mule.modules.neo4j.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.DefaultResult;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.neo4j.Neo4jConnector;
import org.mule.modules.neo4j.connectivity.Neo4jConnectorConnectionManager;
import org.mule.modules.neo4j.process.ProcessAdapter;
import org.mule.modules.neo4j.process.ProcessCallback;
import org.mule.modules.neo4j.process.ProcessTemplate;


/**
 * DeleteRelationshipByIdMessageProcessor invokes the {@link org.mule.modules.neo4j.Neo4jConnector#deleteRelationshipById(long, boolean)} method in {@link Neo4jConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-06-17T03:24:12-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class DeleteRelationshipByIdMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor, OperationMetaDataEnabled
{

    protected Object relationshipId;
    protected long _relationshipIdType;
    protected Object failIfNotFound;
    protected boolean _failIfNotFoundType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets relationshipId
     * 
     * @param value Value to set
     */
    public void setRelationshipId(Object value) {
        this.relationshipId = value;
    }

    /**
     * Sets failIfNotFound
     * 
     * @param value Value to set
     */
    public void setFailIfNotFound(Object value) {
        this.failIfNotFound = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(Neo4jConnectorConnectionManager.class, true, event);
            final Long _transformedRelationshipId = ((Long) evaluateAndTransform(getMuleContext(), event, DeleteRelationshipByIdMessageProcessor.class.getDeclaredField("_relationshipIdType").getGenericType(), null, relationshipId));
            final Boolean _transformedFailIfNotFound = ((Boolean) evaluateAndTransform(getMuleContext(), event, DeleteRelationshipByIdMessageProcessor.class.getDeclaredField("_failIfNotFoundType").getGenericType(), null, failIfNotFound));
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    ((Neo4jConnector) object).deleteRelationshipById(_transformedRelationshipId, _transformedFailIfNotFound);
                    return null;
                }

            }
            , this, event);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("deleteRelationshipById"), event, e);
        }
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        return new DefaultResult<MetaData>(null, (Result.Status.SUCCESS));
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult<MetaData>(new DefaultMetaData(getPojoOrSimpleModel(void.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals(dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        } else {
            return new DefaultSimpleMetaDataModel(dataType);
        }
    }

}
