
package org.mule.modules.neo4j.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.DefaultResult;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.neo4j.Neo4jConnector;
import org.mule.modules.neo4j.connectivity.Neo4jConnectorConnectionManager;
import org.mule.modules.neo4j.model.IndexedRelationship;
import org.mule.modules.neo4j.model.Node;
import org.mule.modules.neo4j.process.ProcessAdapter;
import org.mule.modules.neo4j.process.ProcessCallback;
import org.mule.modules.neo4j.process.ProcessTemplate;


/**
 * CreateUniqueRelationshipOrFailMessageProcessor invokes the {@link org.mule.modules.neo4j.Neo4jConnector#createUniqueRelationshipOrFail(java.lang.String, java.lang.String, java.lang.String, java.lang.String, org.mule.modules.neo4j.model.Node, org.mule.modules.neo4j.model.Node)} method in {@link Neo4jConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-06-17T03:24:12-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class CreateUniqueRelationshipOrFailMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor, OperationMetaDataEnabled
{

    protected Object relationshipName;
    protected String _relationshipNameType;
    protected Object type;
    protected String _typeType;
    protected Object key;
    protected String _keyType;
    protected Object value;
    protected String _valueType;
    protected Object startNode;
    protected Node _startNodeType;
    protected Object endNode;
    protected Node _endNodeType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets value
     * 
     * @param value Value to set
     */
    public void setValue(Object value) {
        this.value = value;
    }

    /**
     * Sets startNode
     * 
     * @param value Value to set
     */
    public void setStartNode(Object value) {
        this.startNode = value;
    }

    /**
     * Sets relationshipName
     * 
     * @param value Value to set
     */
    public void setRelationshipName(Object value) {
        this.relationshipName = value;
    }

    /**
     * Sets type
     * 
     * @param value Value to set
     */
    public void setType(Object value) {
        this.type = value;
    }

    /**
     * Sets endNode
     * 
     * @param value Value to set
     */
    public void setEndNode(Object value) {
        this.endNode = value;
    }

    /**
     * Sets key
     * 
     * @param value Value to set
     */
    public void setKey(Object value) {
        this.key = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(Neo4jConnectorConnectionManager.class, true, event);
            final String _transformedRelationshipName = ((String) evaluateAndTransform(getMuleContext(), event, CreateUniqueRelationshipOrFailMessageProcessor.class.getDeclaredField("_relationshipNameType").getGenericType(), null, relationshipName));
            final String _transformedType = ((String) evaluateAndTransform(getMuleContext(), event, CreateUniqueRelationshipOrFailMessageProcessor.class.getDeclaredField("_typeType").getGenericType(), null, type));
            final String _transformedKey = ((String) evaluateAndTransform(getMuleContext(), event, CreateUniqueRelationshipOrFailMessageProcessor.class.getDeclaredField("_keyType").getGenericType(), null, key));
            final String _transformedValue = ((String) evaluateAndTransform(getMuleContext(), event, CreateUniqueRelationshipOrFailMessageProcessor.class.getDeclaredField("_valueType").getGenericType(), null, value));
            final Node _transformedStartNode = ((Node) evaluateAndTransform(getMuleContext(), event, CreateUniqueRelationshipOrFailMessageProcessor.class.getDeclaredField("_startNodeType").getGenericType(), null, startNode));
            final Node _transformedEndNode = ((Node) evaluateAndTransform(getMuleContext(), event, CreateUniqueRelationshipOrFailMessageProcessor.class.getDeclaredField("_endNodeType").getGenericType(), null, endNode));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((Neo4jConnector) object).createUniqueRelationshipOrFail(_transformedRelationshipName, _transformedType, _transformedKey, _transformedValue, _transformedStartNode, _transformedEndNode);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("createUniqueRelationshipOrFail"), event, e);
        }
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        return new DefaultResult<MetaData>(null, (Result.Status.SUCCESS));
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult<MetaData>(new DefaultMetaData(getPojoOrSimpleModel(IndexedRelationship.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals(dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        } else {
            return new DefaultSimpleMetaDataModel(dataType);
        }
    }

}
