
package org.mule.modules.neo4j.model.transformers;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.neo4j.model.Node;
import org.mule.modules.neo4j.model.holders.NodeExpressionHolder;
import org.mule.modules.neo4j.processors.AbstractExpressionEvaluator;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-06-17T03:24:12-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class NodeExpressionHolderTransformer
    extends AbstractExpressionEvaluator
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == NodeExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == NodeExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {NodeExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(NodeExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return Node.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(Node.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        NodeExpressionHolder holder = ((NodeExpressionHolder) src);
        Node result = new Node();
        try {
            final String _transformedPagedTraverse = ((String) evaluateAndTransform(this.muleContext, event, NodeExpressionHolder.class.getDeclaredField("_pagedTraverseType").getGenericType(), null, holder.getPagedTraverse()));
            result.setPagedTraverse(_transformedPagedTraverse);
            final String _transformedOutgoingRelationships = ((String) evaluateAndTransform(this.muleContext, event, NodeExpressionHolder.class.getDeclaredField("_outgoingRelationshipsType").getGenericType(), null, holder.getOutgoingRelationships()));
            result.setOutgoingRelationships(_transformedOutgoingRelationships);
            final String _transformedTraverse = ((String) evaluateAndTransform(this.muleContext, event, NodeExpressionHolder.class.getDeclaredField("_traverseType").getGenericType(), null, holder.getTraverse()));
            result.setTraverse(_transformedTraverse);
            final String _transformedAllTypedRelationships = ((String) evaluateAndTransform(this.muleContext, event, NodeExpressionHolder.class.getDeclaredField("_allTypedRelationshipsType").getGenericType(), null, holder.getAllTypedRelationships()));
            result.setAllTypedRelationships(_transformedAllTypedRelationships);
            final String _transformedAllRelationships = ((String) evaluateAndTransform(this.muleContext, event, NodeExpressionHolder.class.getDeclaredField("_allRelationshipsType").getGenericType(), null, holder.getAllRelationships()));
            result.setAllRelationships(_transformedAllRelationships);
            final String _transformedOutgoingTypedRelationships = ((String) evaluateAndTransform(this.muleContext, event, NodeExpressionHolder.class.getDeclaredField("_outgoingTypedRelationshipsType").getGenericType(), null, holder.getOutgoingTypedRelationships()));
            result.setOutgoingTypedRelationships(_transformedOutgoingTypedRelationships);
            final String _transformedIncomingRelationships = ((String) evaluateAndTransform(this.muleContext, event, NodeExpressionHolder.class.getDeclaredField("_incomingRelationshipsType").getGenericType(), null, holder.getIncomingRelationships()));
            result.setIncomingRelationships(_transformedIncomingRelationships);
            final String _transformedIncomingTypedRelationships = ((String) evaluateAndTransform(this.muleContext, event, NodeExpressionHolder.class.getDeclaredField("_incomingTypedRelationshipsType").getGenericType(), null, holder.getIncomingTypedRelationships()));
            result.setIncomingTypedRelationships(_transformedIncomingTypedRelationships);
            final String _transformedCreateRelationship = ((String) evaluateAndTransform(this.muleContext, event, NodeExpressionHolder.class.getDeclaredField("_createRelationshipType").getGenericType(), null, holder.getCreateRelationship()));
            result.setCreateRelationship(_transformedCreateRelationship);
            final String _transformedLabels = ((String) evaluateAndTransform(this.muleContext, event, NodeExpressionHolder.class.getDeclaredField("_labelsType").getGenericType(), null, holder.getLabels()));
            result.setLabels(_transformedLabels);
            final String _transformedPath = ((String) evaluateAndTransform(this.muleContext, event, NodeExpressionHolder.class.getDeclaredField("_pathType").getGenericType(), null, holder.getPath()));
            result.setPath(_transformedPath);
            final String _transformedPaths = ((String) evaluateAndTransform(this.muleContext, event, NodeExpressionHolder.class.getDeclaredField("_pathsType").getGenericType(), null, holder.getPaths()));
            result.setPaths(_transformedPaths);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
