
package org.mule.modules.neo4j.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.annotate.JsonValue;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include = JsonSerialize.Inclusion.NON_NULL)
@Generated("com.googlecode.jsonschema2pojo")
@JsonPropertyOrder({
    "order",
    "relationships",
    "uniqueness",
    "return_filter",
    "prune_evaluator",
    "max_depth"
})
public class TraversalQuery {

    @JsonProperty("order")
    private TraversalQuery.Order order;
    @JsonProperty("relationships")
    private List<RelationshipQuery> relationships = new ArrayList<RelationshipQuery>();
    @JsonProperty("uniqueness")
    private TraversalQuery.Uniqueness uniqueness;
    @JsonProperty("return_filter")
    private TraversalScript returnFilter;
    @JsonProperty("prune_evaluator")
    private TraversalScript pruneEvaluator;
    @JsonProperty("max_depth")
    private Integer maxDepth;

    @JsonProperty("order")
    public TraversalQuery.Order getOrder() {
        return order;
    }

    @JsonProperty("order")
    public void setOrder(TraversalQuery.Order order) {
        this.order = order;
    }

    public TraversalQuery withOrder(TraversalQuery.Order order) {
        this.order = order;
        return this;
    }

    @JsonProperty("relationships")
    public List<RelationshipQuery> getRelationships() {
        return relationships;
    }

    @JsonProperty("relationships")
    public void setRelationships(List<RelationshipQuery> relationships) {
        this.relationships = relationships;
    }

    public TraversalQuery withRelationships(List<RelationshipQuery> relationships) {
        this.relationships = relationships;
        return this;
    }

    @JsonProperty("uniqueness")
    public TraversalQuery.Uniqueness getUniqueness() {
        return uniqueness;
    }

    @JsonProperty("uniqueness")
    public void setUniqueness(TraversalQuery.Uniqueness uniqueness) {
        this.uniqueness = uniqueness;
    }

    public TraversalQuery withUniqueness(TraversalQuery.Uniqueness uniqueness) {
        this.uniqueness = uniqueness;
        return this;
    }

    @JsonProperty("return_filter")
    public TraversalScript getReturnFilter() {
        return returnFilter;
    }

    @JsonProperty("return_filter")
    public void setReturnFilter(TraversalScript returnFilter) {
        this.returnFilter = returnFilter;
    }

    public TraversalQuery withReturnFilter(TraversalScript returnFilter) {
        this.returnFilter = returnFilter;
        return this;
    }

    @JsonProperty("prune_evaluator")
    public TraversalScript getPruneEvaluator() {
        return pruneEvaluator;
    }

    @JsonProperty("prune_evaluator")
    public void setPruneEvaluator(TraversalScript pruneEvaluator) {
        this.pruneEvaluator = pruneEvaluator;
    }

    public TraversalQuery withPruneEvaluator(TraversalScript pruneEvaluator) {
        this.pruneEvaluator = pruneEvaluator;
        return this;
    }

    @JsonProperty("max_depth")
    public Integer getMaxDepth() {
        return maxDepth;
    }

    @JsonProperty("max_depth")
    public void setMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }

    public TraversalQuery withMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @Generated("com.googlecode.jsonschema2pojo")
    public static enum Order {

        BREADTH_FIRST("breadth_first"),
        DEPTH_FIRST("depth_first");
        private final String value;
        private static Map<String, TraversalQuery.Order> constants = new HashMap<String, TraversalQuery.Order>();

        static {
            for (TraversalQuery.Order c: TraversalQuery.Order.values()) {
                constants.put(c.value, c);
            }
        }

        private Order(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static TraversalQuery.Order fromValue(String value) {
            TraversalQuery.Order constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("com.googlecode.jsonschema2pojo")
    public static enum Uniqueness {

        NODE_GLOBAL("node_global"),
        NONE("none"),
        RELATIONSHIP_GLOBAL("relationship_global"),
        NODE_PATH("node_path"),
        RELATIONSHIP_PATH("relationship_path");
        private final String value;
        private static Map<String, TraversalQuery.Uniqueness> constants = new HashMap<String, TraversalQuery.Uniqueness>();

        static {
            for (TraversalQuery.Uniqueness c: TraversalQuery.Uniqueness.values()) {
                constants.put(c.value, c);
            }
        }

        private Uniqueness(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static TraversalQuery.Uniqueness fromValue(String value) {
            TraversalQuery.Uniqueness constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
