
package org.mule.modules.neo4j.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.annotate.JsonValue;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include = JsonSerialize.Inclusion.NON_NULL)
@Generated("com.googlecode.jsonschema2pojo")
@JsonPropertyOrder({
    "algorithm",
    "to",
    "relationships",
    "max_depth",
    "cost_property",
    "default_cost"
})
public class PathQuery {

    @JsonProperty("algorithm")
    private PathQuery.Algorithm algorithm;
    @JsonProperty("to")
    private String to;
    @JsonProperty("relationships")
    private RelationshipQuery relationships;
    @JsonProperty("max_depth")
    private Integer maxDepth;
    @JsonProperty("cost_property")
    private String costProperty;
    @JsonProperty("default_cost")
    private Double defaultCost;

    @JsonProperty("algorithm")
    public PathQuery.Algorithm getAlgorithm() {
        return algorithm;
    }

    @JsonProperty("algorithm")
    public void setAlgorithm(PathQuery.Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public PathQuery withAlgorithm(PathQuery.Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @JsonProperty("to")
    public String getTo() {
        return to;
    }

    @JsonProperty("to")
    public void setTo(String to) {
        this.to = to;
    }

    public PathQuery withTo(String to) {
        this.to = to;
        return this;
    }

    @JsonProperty("relationships")
    public RelationshipQuery getRelationships() {
        return relationships;
    }

    @JsonProperty("relationships")
    public void setRelationships(RelationshipQuery relationships) {
        this.relationships = relationships;
    }

    public PathQuery withRelationships(RelationshipQuery relationships) {
        this.relationships = relationships;
        return this;
    }

    @JsonProperty("max_depth")
    public Integer getMaxDepth() {
        return maxDepth;
    }

    @JsonProperty("max_depth")
    public void setMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }

    public PathQuery withMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    @JsonProperty("cost_property")
    public String getCostProperty() {
        return costProperty;
    }

    @JsonProperty("cost_property")
    public void setCostProperty(String costProperty) {
        this.costProperty = costProperty;
    }

    public PathQuery withCostProperty(String costProperty) {
        this.costProperty = costProperty;
        return this;
    }

    @JsonProperty("default_cost")
    public Double getDefaultCost() {
        return defaultCost;
    }

    @JsonProperty("default_cost")
    public void setDefaultCost(Double defaultCost) {
        this.defaultCost = defaultCost;
    }

    public PathQuery withDefaultCost(Double defaultCost) {
        this.defaultCost = defaultCost;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @Generated("com.googlecode.jsonschema2pojo")
    public static enum Algorithm {

        SHORTEST_PATH("shortestPath"),
        ALL_SIMPLE_PATHS("allSimplePaths"),
        ALL_PATHS("allPaths"),
        DIJKSTRA("dijkstra");
        private final String value;
        private static Map<String, PathQuery.Algorithm> constants = new HashMap<String, PathQuery.Algorithm>();

        static {
            for (PathQuery.Algorithm c: PathQuery.Algorithm.values()) {
                constants.put(c.value, c);
            }
        }

        private Algorithm(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static PathQuery.Algorithm fromValue(String value) {
            PathQuery.Algorithm constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
