/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.util.StringUtils;

public class RmiRegistryAgent
implements UMOAgent {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 1099;
    private static final String PROTOCOL_PREFIX = "rmi://";
    public static final String DEFAULT_SERVER_URI = "rmi://localhost:1099";
    private String name = "RMI Agent";
    private Registry rmiRegistry;
    private String serverUri;
    private String host;
    private String port;
    private boolean createRegistry = true;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "Rmi Registry: " + this.serverUri;
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void start() throws UMOException {
        URI uri;
        try {
            uri = new URI(this.serverUri);
        }
        catch (URISyntaxException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
        if (this.rmiRegistry == null) {
            try {
                if (this.createRegistry) {
                    try {
                        this.rmiRegistry = LocateRegistry.createRegistry(uri.getPort());
                    }
                    catch (ExportException e) {
                        this.logger.info((Object)("Registry on " + this.serverUri + " already bound. Attempting to use that instead"));
                        this.rmiRegistry = LocateRegistry.getRegistry(uri.getHost(), uri.getPort());
                    }
                } else {
                    this.rmiRegistry = LocateRegistry.getRegistry(uri.getHost(), uri.getPort());
                }
            }
            catch (RemoteException e) {
                throw new InitialisationException((Throwable)e, (Object)this);
            }
        }
    }

    public void stop() throws UMOException {
        this.rmiRegistry = null;
    }

    public void dispose() {
    }

    public void initialise() throws InitialisationException {
        if (StringUtils.isNotBlank((String)this.serverUri)) {
            return;
        }
        String theHost = StringUtils.defaultIfEmpty((String)this.host, (String)DEFAULT_HOSTNAME);
        String thePort = StringUtils.defaultIfEmpty((String)this.port, (String)String.valueOf(1099));
        this.serverUri = PROTOCOL_PREFIX + theHost + ":" + thePort;
    }

    public Registry getRmiRegistry() {
        return this.rmiRegistry;
    }

    public void setRmiRegistry(Registry rmiRegistry) {
        this.rmiRegistry = rmiRegistry;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public void setServerUri(String serverUri) {
        this.serverUri = serverUri;
    }

    public boolean isCreateRegistry() {
        return this.createRegistry;
    }

    public void setCreateRegistry(boolean createRegistry) {
        this.createRegistry = createRegistry;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}

