/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.kindling.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.module.kindling.adapters.KindlingConnectorConnectionIdentifierAdapter;
import org.mule.module.kindling.connectivity.KindlingConnectorConnectionKey;
import org.mule.module.kindling.connectivity.KindlingConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KindlingConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(KindlingConnectorConnectionFactory.class);
    private KindlingConnectorConnectionManager connectionManager;

    public KindlingConnectorConnectionFactory(KindlingConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof KindlingConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        KindlingConnectorConnectionIdentifierAdapter connector = new KindlingConnectorConnectionIdentifierAdapter();
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof KindlingConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof KindlingConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            ((KindlingConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((KindlingConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((KindlingConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof KindlingConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            return ((KindlingConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof KindlingConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof KindlingConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((KindlingConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((KindlingConnectorConnectionIdentifierAdapter)obj).connect(((KindlingConnectorConnectionKey)key).getUsername(), ((KindlingConnectorConnectionKey)key).getPassword(), ((KindlingConnectorConnectionKey)key).getCompanyName());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

