/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.kindling.client;

import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;
import org.mule.module.kindling.exception.KindlingConnectorException;
import org.mule.module.kindling.exception.KindlingConnectorUnauthorizedException;
import org.mule.module.kindling.model.KindlingCollection;
import org.mule.module.kindling.model.KindlingEntity;
import org.mule.module.kindling.types.KindlingWebResourceMethods;

public class KindlingClientUtils {
    private static final ObjectMapper jacksonMapper = new ObjectMapper();

    public static JavaType constructKindlingCollectionType(Class<? extends KindlingEntity> classType) {
        return jacksonMapper.getTypeFactory().constructParametricType(KindlingCollection.class, new Class[]{classType});
    }

    public static String transformObjectToJson(Object o) throws KindlingConnectorException {
        try {
            return jacksonMapper.writeValueAsString(o);
        }
        catch (JsonGenerationException e) {
            throw new KindlingConnectorException("Cannot generate the Json from object", e);
        }
        catch (JsonMappingException e) {
            throw new KindlingConnectorException("Cannot map the Json from object", e);
        }
        catch (IOException e) {
            throw new KindlingConnectorException(e);
        }
    }

    public static <T> T webResourceCallWithJavaType(JavaType jtype, Class<T> type, WebResource wr, String loggedUser, KindlingWebResourceMethods method) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return KindlingClientUtils.webResourceCallWithJavaType(jtype, type, wr, loggedUser, method, null);
    }

    public static <T> T webResourceCallWithJavaType(JavaType jtype, Class<T> type, WebResource wr, String loggedUser, KindlingWebResourceMethods method, String requestBody) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        String json = KindlingClientUtils.webResourceCall(wr, loggedUser, method, null);
        ByteArrayInputStream is = new ByteArrayInputStream(json.getBytes());
        try {
            return (T)jacksonMapper.readValue((InputStream)is, jtype);
        }
        catch (JsonParseException e) {
            throw new KindlingConnectorException("ERROR - Error Parsing the JSON", e);
        }
        catch (JsonMappingException e) {
            throw new KindlingConnectorException("ERROR - Error Mapping the JSON", e);
        }
        catch (IOException e) {
            throw new KindlingConnectorException(e);
        }
    }

    public static <T> T webResourceCallWithClassType(Class<T> type, WebResource wr, String loggedUser, KindlingWebResourceMethods method) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return KindlingClientUtils.webResourceCallWithClassType(type, wr, loggedUser, method, null);
    }

    public static <T> T webResourceCallWithClassType(Class<T> type, WebResource wr, String loggedUser, KindlingWebResourceMethods method, String requestBody) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        String json = KindlingClientUtils.webResourceCall(wr, loggedUser, method, null);
        ByteArrayInputStream is = new ByteArrayInputStream(json.getBytes());
        try {
            return (T)jacksonMapper.readValue((InputStream)is, type);
        }
        catch (JsonParseException e) {
            throw new KindlingConnectorException("ERROR - Error Parsing the JSON", e);
        }
        catch (JsonMappingException e) {
            throw new KindlingConnectorException("ERROR - Error Mapping the JSON", e);
        }
        catch (IOException e) {
            throw new KindlingConnectorException(e);
        }
    }

    public static String webResourceCall(WebResource wr, String loggedUser, KindlingWebResourceMethods method) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return KindlingClientUtils.webResourceCall(wr, loggedUser, method, null);
    }

    public static String webResourceCall(WebResource wr, String loggedUser, KindlingWebResourceMethods method, String requestBody) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        try {
            return KindlingClientUtils.webResourceCallByEnumType(wr, method, requestBody);
        }
        catch (UniformInterfaceException e) {
            int statusCode = e.getResponse().getStatus();
            if (statusCode == 204) {
                return null;
            }
            if (statusCode == 401) {
                throw new KindlingConnectorUnauthorizedException(loggedUser);
            }
            throw new KindlingConnectorException("ERROR - statusCode: " + statusCode, e);
        }
    }

    private static String webResourceCallByEnumType(WebResource wr, KindlingWebResourceMethods method, String requestBody) {
        if (KindlingWebResourceMethods.GET.equals((Object)method)) {
            return (String)wr.type(MediaType.APPLICATION_JSON_TYPE).get(String.class);
        }
        if (KindlingWebResourceMethods.POST.equals((Object)method)) {
            return (String)wr.type(MediaType.APPLICATION_JSON_TYPE).post(String.class, (Object)requestBody);
        }
        if (KindlingWebResourceMethods.PUT.equals((Object)method)) {
            return (String)wr.type(MediaType.APPLICATION_JSON_TYPE).put(String.class, (Object)requestBody);
        }
        if (KindlingWebResourceMethods.DELETE.equals((Object)method)) {
            return (String)wr.type(MediaType.APPLICATION_JSON_TYPE).delete(String.class);
        }
        return null;
    }
}

