/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.AbstractSingleResourceTransaction;
import org.mule.transaction.IllegalTransactionStateException;

public class JPATransaction
extends AbstractSingleResourceTransaction {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    EntityManager entityManager;
    EntityTransaction transaction;

    public JPATransaction(MuleContext muleContext) {
        super(muleContext);
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void bindResource(Object key, Object resource) throws TransactionException {
        this.logger.debug((Object)("Binding JPA transaction: " + super.getId()));
        if (!(key instanceof EntityManagerFactory) || !(resource instanceof EntityManager)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCanOnlyBindToResources((String)"javax.persistence.EntityManagerFactory/javax.persistence.EntityManager"));
        }
        this.entityManager = (EntityManager)resource;
        this.transaction = this.entityManager.getTransaction();
        this.transaction.begin();
        super.bindResource(key, resource);
    }

    protected void doBegin() throws TransactionException {
    }

    protected void doCommit() throws TransactionException {
        this.logger.debug((Object)("Committing JPA transaction: " + super.getId()));
        this.transaction.commit();
    }

    protected void doRollback() throws TransactionException {
        this.logger.debug((Object)("Rolling back JPA transaction: " + super.getId()));
        this.transaction.rollback();
    }
}

