
package org.mule.module.jpa.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jpa.JPAModule;
import org.mule.module.jpa.adapters.JPAModuleProcessAdapter;
import org.mule.module.jpa.process.ProcessAdapter;
import org.mule.module.jpa.process.ProcessCallback;
import org.mule.module.jpa.process.ProcessTemplate;


/**
 * FindMessageProcessor invokes the {@link org.mule.module.jpa.JPAModule#find(java.lang.String, java.lang.Object, java.lang.Boolean)} method in {@link JPAModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-09-30T11:39:52-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class FindMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object entityClass;
    protected String _entityClassType;
    protected Object id;
    protected Object _idType;
    protected Object flush;
    protected Boolean _flushType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets id
     * 
     * @param value Value to set
     */
    public void setId(Object value) {
        this.id = value;
    }

    /**
     * Sets flush
     * 
     * @param value Value to set
     */
    public void setFlush(Object value) {
        this.flush = value;
    }

    /**
     * Sets entityClass
     * 
     * @param value Value to set
     */
    public void setEntityClass(Object value) {
        this.entityClass = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(JPAModuleProcessAdapter.class, false, event);
            final String _transformedEntityClass = ((String) evaluateAndTransform(getMuleContext(), event, FindMessageProcessor.class.getDeclaredField("_entityClassType").getGenericType(), null, entityClass));
            final Object _transformedId = ((Object) evaluateAndTransform(getMuleContext(), event, FindMessageProcessor.class.getDeclaredField("_idType").getGenericType(), null, id));
            final Boolean _transformedFlush = ((Boolean) evaluateAndTransform(getMuleContext(), event, FindMessageProcessor.class.getDeclaredField("_flushType").getGenericType(), null, flush));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((JPAModule) object).find(_transformedEntityClass, _transformedId, _transformedFlush);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("find"), event, e);
        }
    }

}
