
package org.mule.module.jpa.processors;

import java.util.List;
import javax.annotation.Generated;
import javax.persistence.criteria.CriteriaQuery;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.jpa.JPAModule;
import org.mule.module.jpa.adapters.JPAModuleProcessAdapter;
import org.mule.module.jpa.process.ProcessAdapter;
import org.mule.module.jpa.process.ProcessCallback;
import org.mule.module.jpa.process.ProcessTemplate;


/**
 * QueryMessageProcessor invokes the {@link org.mule.module.jpa.JPAModule#query(javax.persistence.criteria.CriteriaQuery, java.lang.String, java.lang.String, java.lang.Object, java.lang.Boolean)} method in {@link JPAModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-06-26T06:27:31-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class QueryMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object criteria;
    protected CriteriaQuery _criteriaType;
    protected Object statement;
    protected String _statementType;
    protected Object namedQuery;
    protected String _namedQueryType;
    protected Object queryParameters;
    protected Object _queryParametersType;
    protected Object flush;
    protected Boolean _flushType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets statement
     * 
     * @param value Value to set
     */
    public void setStatement(Object value) {
        this.statement = value;
    }

    /**
     * Sets namedQuery
     * 
     * @param value Value to set
     */
    public void setNamedQuery(Object value) {
        this.namedQuery = value;
    }

    /**
     * Sets flush
     * 
     * @param value Value to set
     */
    public void setFlush(Object value) {
        this.flush = value;
    }

    /**
     * Sets criteria
     * 
     * @param value Value to set
     */
    public void setCriteria(Object value) {
        this.criteria = value;
    }

    /**
     * Sets queryParameters
     * 
     * @param value Value to set
     */
    public void setQueryParameters(Object value) {
        this.queryParameters = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(JPAModuleProcessAdapter.class, false, event);
            final CriteriaQuery _transformedCriteria = ((CriteriaQuery) evaluateAndTransform(getMuleContext(), event, QueryMessageProcessor.class.getDeclaredField("_criteriaType").getGenericType(), null, criteria));
            final String _transformedStatement = ((String) evaluateAndTransform(getMuleContext(), event, QueryMessageProcessor.class.getDeclaredField("_statementType").getGenericType(), null, statement));
            final String _transformedNamedQuery = ((String) evaluateAndTransform(getMuleContext(), event, QueryMessageProcessor.class.getDeclaredField("_namedQueryType").getGenericType(), null, namedQuery));
            final Object _transformedQueryParameters = ((Object) evaluateAndTransform(getMuleContext(), event, QueryMessageProcessor.class.getDeclaredField("_queryParametersType").getGenericType(), null, queryParameters));
            final Boolean _transformedFlush = ((Boolean) evaluateAndTransform(getMuleContext(), event, QueryMessageProcessor.class.getDeclaredField("_flushType").getGenericType(), null, flush));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((JPAModule) object).query(_transformedCriteria, _transformedStatement, _transformedNamedQuery, _transformedQueryParameters, _transformedFlush);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("query"), event, e);
        }
    }

}
